"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HostsContainer = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _constants = require("../../../../common/constants");
var _details = require("./details");
var _model = require("../store/model");
var _ml_host_conditional_container = require("../../../common/components/ml/conditional_links/ml_host_conditional_container");
var _hosts = require("./hosts");
var _types = require("./types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getHostsTabPath = () => `${_constants.HOSTS_PATH}/:tabName(` + `${_model.HostsTableType.hosts}|` + `${_model.HostsTableType.uncommonProcesses}|` + `${_model.HostsTableType.anomalies}|` + `${_model.HostsTableType.events}|` + `${_model.HostsTableType.risk}|` + `${_model.HostsTableType.sessions})`;
const getHostDetailsTabPath = () => `${_types.hostDetailsPagePath}/:tabName(` + `${_model.HostsTableType.authentications}|` + `${_model.HostsTableType.uncommonProcesses}|` + `${_model.HostsTableType.anomalies}|` + `${_model.HostsTableType.events}|` + `${_model.HostsTableType.risk}|` + `${_model.HostsTableType.sessions})`;
const HostsContainer = /*#__PURE__*/_react.default.memo(() => /*#__PURE__*/_react.default.createElement(_reactRouterDom.Switch, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
  path: `${_constants.HOSTS_PATH}/ml-hosts`
}, /*#__PURE__*/_react.default.createElement(_ml_host_conditional_container.MlHostConditionalContainer, null)), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route // Compatibility redirect for the old external alert path to events page with external alerts showing.
, {
  path: `${_constants.HOSTS_PATH}/externalAlerts`,
  render: ({
    location: {
      search = ''
    }
  }) => /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
    to: {
      pathname: `${_constants.HOSTS_PATH}/${_model.HostsTableType.events}`,
      search: `${search}&onlyExternalAlerts=true`
    }
  })
}), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
  path: getHostsTabPath()
}, /*#__PURE__*/_react.default.createElement(_hosts.Hosts, null)), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
  path: getHostDetailsTabPath(),
  render: ({
    match: {
      params: {
        detailName
      }
    }
  }) => /*#__PURE__*/_react.default.createElement(_details.HostDetails, {
    hostDetailsPagePath: _types.hostDetailsPagePath,
    detailName: decodeURIComponent(detailName)
  })
}), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route // Redirect to the first tab when tabName is not present.
, {
  path: _types.hostDetailsPagePath,
  render: ({
    match: {
      params: {
        detailName
      }
    },
    location: {
      search = ''
    }
  }) => /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
    to: {
      pathname: `${_constants.HOSTS_PATH}/name/${detailName}/${_model.HostsTableType.authentications}`,
      search
    }
  })
}), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route // Compatibility redirect for the old user detail path.
, {
  path: `${_constants.HOSTS_PATH}/:detailName/:tabName?`,
  render: ({
    match: {
      params: {
        detailName,
        tabName = _model.HostsTableType.authentications
      }
    },
    location: {
      search = ''
    }
  }) => /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
    to: {
      pathname: `${_constants.HOSTS_PATH}/name/${detailName}/${tabName}`,
      search
    }
  })
}), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route // Redirect to the first tab when tabName is not present.
, {
  path: _constants.HOSTS_PATH,
  render: ({
    location: {
      search = ''
    }
  }) => /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
    to: {
      pathname: `${_constants.HOSTS_PATH}/${_model.HostsTableType.hosts}`,
      search
    }
  })
})));
exports.HostsContainer = HostsContainer;
HostsContainer.displayName = 'HostsContainer';