"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.type = exports.getTrailingBreadcrumbs = void 0;
var _fp = require("lodash/fp");
var _store = require("../../store");
var _model = require("../../store/model");
var _redirect_to_hosts = require("../../../../common/components/link_to/redirect_to_hosts");
var i18n = _interopRequireWildcard(require("../translations"));
var _types = require("../../../../app/types");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const type = _store.hostsModel.HostsType.details;
exports.type = type;
const TabNameMappedToI18nKey = {
  [_model.HostsTableType.hosts]: i18n.NAVIGATION_ALL_HOSTS_TITLE,
  [_model.HostsTableType.authentications]: i18n.NAVIGATION_AUTHENTICATIONS_TITLE,
  [_model.HostsTableType.uncommonProcesses]: i18n.NAVIGATION_UNCOMMON_PROCESSES_TITLE,
  [_model.HostsTableType.anomalies]: i18n.NAVIGATION_ANOMALIES_TITLE,
  [_model.HostsTableType.events]: i18n.NAVIGATION_EVENTS_TITLE,
  [_model.HostsTableType.risk]: i18n.NAVIGATION_HOST_RISK_TITLE,
  [_model.HostsTableType.sessions]: i18n.NAVIGATION_SESSIONS_TITLE
};
const getTrailingBreadcrumbs = (params, getSecuritySolutionUrl) => {
  let breadcrumb = [];
  if (params.detailName != null) {
    breadcrumb = [...breadcrumb, {
      text: params.detailName,
      href: getSecuritySolutionUrl({
        path: (0, _redirect_to_hosts.getHostDetailsUrl)(params.detailName, ''),
        deepLinkId: _types.SecurityPageName.hosts
      })
    }];
  }
  if (params.tabName != null) {
    const tabName = (0, _fp.get)('tabName', params);
    if (!tabName) return breadcrumb;
    breadcrumb = [...breadcrumb, {
      text: TabNameMappedToI18nKey[tabName],
      href: ''
    }];
  }
  return breadcrumb;
};
exports.getTrailingBreadcrumbs = getTrailingBreadcrumbs;