"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HostDetails = void 0;
var _eui = require("@elastic/eui");
var _fp = require("lodash/fp");
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _esQuery = require("@kbn/es-query");
var _common = require("@kbn/data-plugin/common");
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _alerts_by_status = require("../../../../overview/components/detection_response/alerts_by_status");
var _use_signal_index = require("../../../../detections/containers/detection_engine/alerts/use_signal_index");
var _use_alerts_privileges = require("../../../../detections/containers/detection_engine/alerts/use_alerts_privileges");
var _constants = require("../../../../common/store/inputs/constants");
var _search_strategy = require("../../../../../common/search_strategy");
var _types = require("../../../../app/types");
var _filters_global = require("../../../../common/components/filters_global");
var _header_page = require("../../../../common/components/header_page");
var _last_event_time = require("../../../../common/components/last_event_time");
var _anomaly_table_provider = require("../../../../common/components/ml/anomaly/anomaly_table_provider");
var _host_to_criteria = require("../../../../common/components/ml/criteria/host_to_criteria");
var _has_ml_user_permissions = require("../../../../../common/machine_learning/has_ml_user_permissions");
var _use_ml_capabilities = require("../../../../common/components/ml/hooks/use_ml_capabilities");
var _score_interval_to_datetime = require("../../../../common/components/ml/score/score_interval_to_datetime");
var _tab_navigation_with_breadcrumbs = require("../../../../common/components/navigation/tab_navigation_with_breadcrumbs");
var _host_overview = require("../../../../overview/components/host_overview");
var _search_bar = require("../../../../common/components/search_bar");
var _page_wrapper = require("../../../../common/components/page_wrapper");
var _use_global_time = require("../../../../common/containers/use_global_time");
var _kibana = require("../../../../common/lib/kibana");
var _store = require("../../../../common/store");
var _actions = require("../../store/actions");
var _actions2 = require("../../../../common/store/inputs/actions");
var _spy_routes = require("../../../../common/utils/route/spy_routes");
var _details_tabs = require("./details_tabs");
var _nav_tabs = require("./nav_tabs");
var _utils = require("./utils");
var _helpers = require("./helpers");
var _helpers2 = require("../../../../timelines/components/timeline/helpers");
var _use_full_screen = require("../../../../common/containers/use_full_screen");
var _display = require("../display");
var _use_selector = require("../../../../common/hooks/use_selector");
var _details = require("../../containers/hosts/details");
var _manage_query = require("../../../../common/components/page/manage_query");
var _use_invalid_filter_query = require("../../../../common/hooks/use_invalid_filter_query");
var _sourcerer = require("../../../../common/containers/sourcerer");
var _landing_page = require("../../../../common/components/landing_page");
var _alert_count_by_status = require("../../../../common/components/alert_count_by_status");
var _use_license = require("../../../../common/hooks/use_license");
var _responder_action_button = require("../../../../detections/components/endpoint_responder/responder_action_button");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ES_HOST_FIELD = 'host.hostname';
const HostOverviewManage = (0, _manage_query.manageQuery)(_host_overview.HostOverview);
const HostDetailsComponent = ({
  detailName,
  hostDetailsPagePath
}) => {
  var _hostOverview$endpoin, _hostOverview$endpoin2;
  const dispatch = (0, _reactRedux.useDispatch)();
  const getTable = (0, _react.useMemo)(() => _securitysolutionDataTable.dataTableSelectors.getTableByIdSelector(), []);
  const graphEventId = (0, _use_selector.useShallowEqualSelector)(state => {
    var _getTable;
    return ((_getTable = getTable(state, _securitysolutionDataTable.TableId.hostsPageEvents)) !== null && _getTable !== void 0 ? _getTable : _securitysolutionDataTable.tableDefaults).graphEventId;
  });
  const getGlobalFiltersQuerySelector = (0, _react.useMemo)(() => _store.inputsSelectors.globalFiltersQuerySelector(), []);
  const getGlobalQuerySelector = (0, _react.useMemo)(() => _store.inputsSelectors.globalQuerySelector(), []);
  const query = (0, _use_selector.useDeepEqualSelector)(getGlobalQuerySelector);
  const globalFilters = (0, _use_selector.useDeepEqualSelector)(getGlobalFiltersQuerySelector);
  const {
    to,
    from,
    deleteQuery,
    setQuery,
    isInitializing
  } = (0, _use_global_time.useGlobalTime)();
  const {
    globalFullScreen
  } = (0, _use_full_screen.useGlobalFullScreen)();
  const {
    signalIndexName
  } = (0, _use_signal_index.useSignalIndex)();
  const capabilities = (0, _use_ml_capabilities.useMlCapabilities)();
  const {
    services: {
      uiSettings
    }
  } = (0, _kibana.useKibana)();
  const hostDetailsPageFilters = (0, _react.useMemo)(() => (0, _helpers.getHostDetailsPageFilters)(detailName), [detailName]);
  const isEnterprisePlus = (0, _use_license.useLicense)().isEnterprise();
  const narrowDateRange = (0, _react.useCallback)((score, interval) => {
    const fromTo = (0, _score_interval_to_datetime.scoreIntervalToDateTime)(score, interval);
    dispatch((0, _actions2.setAbsoluteRangeDatePicker)({
      id: _constants.InputsModelId.global,
      from: fromTo.from,
      to: fromTo.to
    }));
  }, [dispatch]);
  const {
    indexPattern,
    indicesExist,
    selectedPatterns
  } = (0, _sourcerer.useSourcererDataView)();
  const [loading, {
    inspect,
    hostDetails: hostOverview,
    id,
    refetch
  }] = (0, _details.useHostDetails)({
    endDate: to,
    startDate: from,
    hostName: detailName,
    indexNames: selectedPatterns,
    skip: selectedPatterns.length === 0
  });
  const [rawFilteredQuery, kqlError] = (0, _react.useMemo)(() => {
    try {
      return [(0, _esQuery.buildEsQuery)(indexPattern, [query], [...hostDetailsPageFilters, ...globalFilters], (0, _common.getEsQueryConfig)(uiSettings))];
    } catch (e) {
      return [undefined, e];
    }
  }, [globalFilters, indexPattern, query, uiSettings, hostDetailsPageFilters]);
  const stringifiedAdditionalFilters = JSON.stringify(rawFilteredQuery);
  (0, _use_invalid_filter_query.useInvalidFilterQuery)({
    id: _details.ID,
    filterQuery: stringifiedAdditionalFilters,
    kqlError,
    query,
    startDate: from,
    endDate: to
  });
  (0, _react.useEffect)(() => {
    dispatch((0, _actions.setHostDetailsTablesActivePageToZero)());
  }, [dispatch, detailName]);
  const isPlatinumOrTrialLicense = (0, _use_ml_capabilities.useMlCapabilities)().isPlatinumOrTrialLicense;
  const {
    hasKibanaREAD,
    hasIndexRead
  } = (0, _use_alerts_privileges.useAlertsPrivileges)();
  const canReadAlerts = hasKibanaREAD && hasIndexRead;
  const entityFilter = (0, _react.useMemo)(() => ({
    field: ES_HOST_FIELD,
    value: detailName
  }), [detailName]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, indicesExist ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiWindowEvent, {
    event: "resize",
    handler: _fp.noop
  }), /*#__PURE__*/_react.default.createElement(_filters_global.FiltersGlobal, {
    show: (0, _helpers2.showGlobalFilters)({
      globalFullScreen,
      graphEventId
    })
  }, /*#__PURE__*/_react.default.createElement(_search_bar.SiemSearchBar, {
    indexPattern: indexPattern,
    id: _constants.InputsModelId.global
  })), /*#__PURE__*/_react.default.createElement(_page_wrapper.SecuritySolutionPageWrapper, {
    noPadding: globalFullScreen,
    "data-test-subj": "hostDetailsPage"
  }, /*#__PURE__*/_react.default.createElement(_display.Display, {
    show: !globalFullScreen
  }, /*#__PURE__*/_react.default.createElement(_header_page.HeaderPage, {
    border: true,
    subtitle: /*#__PURE__*/_react.default.createElement(_last_event_time.LastEventTime, {
      indexKey: _search_strategy.LastEventIndexKey.hostDetails,
      hostName: detailName,
      indexNames: selectedPatterns
    }),
    title: detailName,
    rightSideItems: [((_hostOverview$endpoin = hostOverview.endpoint) === null || _hostOverview$endpoin === void 0 ? void 0 : _hostOverview$endpoin.fleetAgentId) && /*#__PURE__*/_react.default.createElement(_responder_action_button.ResponderActionButton, {
      endpointId: (_hostOverview$endpoin2 = hostOverview.endpoint) === null || _hostOverview$endpoin2 === void 0 ? void 0 : _hostOverview$endpoin2.fleetAgentId
    })]
  }), /*#__PURE__*/_react.default.createElement(_anomaly_table_provider.AnomalyTableProvider, {
    criteriaFields: (0, _host_to_criteria.hostToCriteria)(hostOverview),
    startDate: from,
    endDate: to,
    skip: isInitializing
  }, ({
    isLoadingAnomaliesData,
    anomaliesData,
    jobNameById
  }) => /*#__PURE__*/_react.default.createElement(HostOverviewManage, {
    id: id,
    isInDetailsSidePanel: false,
    data: hostOverview,
    anomaliesData: anomaliesData,
    isLoadingAnomaliesData: isLoadingAnomaliesData,
    loading: loading,
    startDate: from,
    endDate: to,
    narrowDateRange: narrowDateRange,
    setQuery: setQuery,
    refetch: refetch,
    inspect: inspect,
    hostName: detailName,
    indexNames: selectedPatterns,
    jobNameById: jobNameById
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), canReadAlerts && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_alerts_by_status.AlertsByStatus, {
    signalIndexName: signalIndexName,
    entityFilter: entityFilter,
    additionalFilters: rawFilteredQuery ? [rawFilteredQuery] : []
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_alert_count_by_status.AlertCountByRuleByStatus, {
    entityFilter: entityFilter,
    signalIndexName: signalIndexName,
    additionalFilters: rawFilteredQuery ? [rawFilteredQuery] : []
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)), /*#__PURE__*/_react.default.createElement(_tab_navigation_with_breadcrumbs.TabNavigationWithBreadcrumbs, {
    navTabs: (0, _nav_tabs.navTabsHostDetails)({
      hasMlUserPermissions: (0, _has_ml_user_permissions.hasMlUserPermissions)(capabilities),
      isRiskyHostsEnabled: isPlatinumOrTrialLicense,
      hostName: detailName,
      isEnterprise: isEnterprisePlus
    })
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)), /*#__PURE__*/_react.default.createElement(_details_tabs.HostDetailsTabs, {
    indexNames: selectedPatterns,
    isInitializing: isInitializing,
    deleteQuery: deleteQuery,
    hostDetailsFilter: hostDetailsPageFilters,
    to: to,
    from: from,
    detailName: detailName,
    type: _utils.type,
    setQuery: setQuery,
    filterQuery: stringifiedAdditionalFilters,
    hostDetailsPagePath: hostDetailsPagePath,
    indexPattern: indexPattern
  }))) : /*#__PURE__*/_react.default.createElement(_landing_page.LandingPageComponent, null), /*#__PURE__*/_react.default.createElement(_spy_routes.SpyRoute, {
    pageName: _types.SecurityPageName.hosts
  }));
};
HostDetailsComponent.displayName = 'HostDetailsComponent';
const HostDetails = /*#__PURE__*/_react.default.memo(HostDetailsComponent);
exports.HostDetails = HostDetails;