"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getHostDetailsPageFilters = exports.getHostDetailsEventsKqlQueryExpression = void 0;
var _kuery = require("../../../../common/lib/kuery");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/** Returns the kqlQueryExpression for the `Events` widget on the `Host Details` page */
const getHostDetailsEventsKqlQueryExpression = ({
  filterQueryExpression,
  hostName
}) => {
  if (filterQueryExpression.length) {
    return `${filterQueryExpression}${hostName.length ? ` and host.name: ${(0, _kuery.escapeQueryValue)(hostName)}` : ''}`;
  } else {
    return hostName.length ? `host.name: ${(0, _kuery.escapeQueryValue)(hostName)}` : '';
  }
};
exports.getHostDetailsEventsKqlQueryExpression = getHostDetailsEventsKqlQueryExpression;
const getHostDetailsPageFilters = hostName => [{
  meta: {
    alias: null,
    negate: false,
    disabled: false,
    type: 'phrase',
    key: 'host.name',
    value: hostName,
    params: {
      query: hostName
    }
  },
  query: {
    match: {
      'host.name': {
        query: hostName,
        type: 'phrase'
      }
    }
  }
}];
exports.getHostDetailsPageFilters = getHostDetailsPageFilters;