"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useUncommonProcesses = exports.ID = void 0;
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _react = require("react");
var _helpers = require("../../../components/paginated_table/helpers");
var _helpers2 = require("../../../../common/containers/helpers");
var _store = require("../../store");
var _search_strategy = require("../../../../../common/search_strategy");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_selector = require("../../../../common/hooks/use_selector");
var _use_search_strategy = require("../../../../common/containers/use_search_strategy");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ID = 'hostsUncommonProcessesQuery';
exports.ID = ID;
const useUncommonProcesses = ({
  endDate,
  filterQuery,
  indexNames,
  skip = false,
  startDate,
  type
}) => {
  const getUncommonProcessesSelector = (0, _react.useMemo)(() => _store.hostsSelectors.uncommonProcessesSelector(), []);
  const {
    activePage,
    limit
  } = (0, _use_selector.useDeepEqualSelector)(state => getUncommonProcessesSelector(state, type));
  const [uncommonProcessesRequest, setUncommonProcessesRequest] = (0, _react.useState)(null);
  const wrappedLoadMore = (0, _react.useCallback)(newActivePage => {
    setUncommonProcessesRequest(prevRequest => {
      if (!prevRequest) {
        return prevRequest;
      }
      return {
        ...prevRequest,
        pagination: (0, _helpers.generateTablePaginationOptions)(newActivePage, limit)
      };
    });
  }, [limit]);
  const {
    loading,
    result: response,
    search,
    refetch,
    inspect
  } = (0, _use_search_strategy.useSearchStrategy)({
    factoryQueryType: _search_strategy.HostsQueries.uncommonProcesses,
    initialResult: {
      edges: [],
      totalCount: -1,
      pageInfo: {
        activePage: 0,
        fakeTotalCount: 0,
        showMorePagesIndicator: false
      }
    },
    errorMessage: i18n.FAIL_UNCOMMON_PROCESSES,
    abort: skip
  });
  const uncommonProcessesResponse = (0, _react.useMemo)(() => ({
    id: ID,
    inspect,
    isInspected: false,
    loadPage: wrappedLoadMore,
    pageInfo: response.pageInfo,
    refetch,
    totalCount: response.totalCount,
    uncommonProcesses: response.edges
  }), [inspect, refetch, response.edges, response.pageInfo, response.totalCount, wrappedLoadMore]);
  (0, _react.useEffect)(() => {
    setUncommonProcessesRequest(prevRequest => {
      const myRequest = {
        ...(prevRequest !== null && prevRequest !== void 0 ? prevRequest : {}),
        defaultIndex: indexNames,
        factoryQueryType: _search_strategy.HostsQueries.uncommonProcesses,
        filterQuery: (0, _helpers2.createFilter)(filterQuery),
        pagination: (0, _helpers.generateTablePaginationOptions)(activePage, limit),
        timerange: {
          interval: '12h',
          from: startDate,
          to: endDate
        },
        sort: {}
      };
      if (!(0, _fastDeepEqual.default)(prevRequest, myRequest)) {
        return myRequest;
      }
      return prevRequest;
    });
  }, [activePage, indexNames, endDate, filterQuery, limit, startDate]);
  (0, _react.useEffect)(() => {
    if (!skip && uncommonProcessesRequest) {
      search(uncommonProcessesRequest);
    }
  }, [search, skip, uncommonProcessesRequest]);
  return [loading, uncommonProcessesResponse];
};
exports.useUncommonProcesses = useUncommonProcesses;