"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useHostDetails = exports.ID = void 0;
var _react = require("react");
var _hosts = require("../../../../../../common/search_strategy/security_solution/hosts");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_search_strategy = require("../../../../../common/containers/use_search_strategy");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ID = 'hostsDetailsQuery';
exports.ID = ID;
const useHostDetails = ({
  endDate,
  hostName,
  indexNames,
  id = ID,
  skip = false,
  startDate
}) => {
  const {
    loading,
    result: response,
    search,
    refetch,
    inspect
  } = (0, _use_search_strategy.useSearchStrategy)({
    factoryQueryType: _hosts.HostsQueries.details,
    initialResult: {
      hostDetails: {}
    },
    errorMessage: i18n.FAIL_HOST_OVERVIEW,
    abort: skip
  });
  const hostDetailsResponse = (0, _react.useMemo)(() => ({
    endDate,
    hostDetails: response.hostDetails,
    id,
    inspect,
    isInspected: false,
    refetch,
    startDate
  }), [endDate, response.hostDetails, id, inspect, refetch, startDate]);
  const hostDetailsRequest = (0, _react.useMemo)(() => ({
    defaultIndex: indexNames,
    factoryQueryType: _hosts.HostsQueries.details,
    hostName,
    timerange: {
      interval: '12h',
      from: startDate,
      to: endDate
    }
  }), [endDate, hostName, indexNames, startDate]);
  (0, _react.useEffect)(() => {
    if (!skip) {
      search(hostDetailsRequest);
    }
  }, [hostDetailsRequest, search, skip]);
  return [loading, hostDetailsResponse];
};
exports.useHostDetails = useHostDetails;