"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UNIT = exports.UNCOMMON_PROCESSES = exports.ROWS_5 = exports.ROWS_10 = exports.NUMBER_OF_INSTANCES = exports.NUMBER_OF_HOSTS = exports.NAME = exports.LAST_USER = exports.LAST_COMMAND = exports.HOSTS = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const UNCOMMON_PROCESSES = _i18n.i18n.translate('xpack.securitySolution.authenticationsTable.uncommonProcessTable', {
  defaultMessage: 'Uncommon processes'
});
exports.UNCOMMON_PROCESSES = UNCOMMON_PROCESSES;
const UNIT = totalCount => _i18n.i18n.translate('xpack.securitySolution.uncommonProcessTable.unit', {
  values: {
    totalCount
  },
  defaultMessage: `{totalCount, plural, =1 {process} other {processes}}`
});
exports.UNIT = UNIT;
const HOSTS = _i18n.i18n.translate('xpack.securitySolution.uncommonProcessTable.hostsTitle', {
  defaultMessage: 'Host names'
});
exports.HOSTS = HOSTS;
const NUMBER_OF_HOSTS = _i18n.i18n.translate('xpack.securitySolution.uncommonProcessTable.numberOfHostsTitle', {
  defaultMessage: 'Hosts'
});
exports.NUMBER_OF_HOSTS = NUMBER_OF_HOSTS;
const NUMBER_OF_INSTANCES = _i18n.i18n.translate('xpack.securitySolution.uncommonProcessTable.numberOfInstances', {
  defaultMessage: 'Instances'
});
exports.NUMBER_OF_INSTANCES = NUMBER_OF_INSTANCES;
const LAST_COMMAND = _i18n.i18n.translate('xpack.securitySolution.uncommonProcessTable.lastCommandTitle', {
  defaultMessage: 'Last command'
});
exports.LAST_COMMAND = LAST_COMMAND;
const LAST_USER = _i18n.i18n.translate('xpack.securitySolution.uncommonProcessTable.lastUserTitle', {
  defaultMessage: 'Last user'
});
exports.LAST_USER = LAST_USER;
const NAME = _i18n.i18n.translate('xpack.securitySolution.uncommonProcessTable.nameTitle', {
  defaultMessage: 'Process name'
});
exports.NAME = NAME;
const ROWS_5 = _i18n.i18n.translate('xpack.securitySolution.uncommonProcessTable.rows', {
  values: {
    numRows: 5
  },
  defaultMessage: '{numRows} {numRows, plural, =0 {rows} =1 {row} other {rows}}'
});
exports.ROWS_5 = ROWS_5;
const ROWS_10 = _i18n.i18n.translate('xpack.securitySolution.uncommonProcessTable.rows', {
  values: {
    numRows: 10
  },
  defaultMessage: '{numRows} {numRows, plural, =0 {rows} =1 {row} other {rows}}'
});
exports.ROWS_10 = ROWS_10;