"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getUncommonColumnsCurated = exports.getHostNames = exports.getArgs = exports.UncommonProcessTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _store = require("../../store");
var _empty_value = require("../../../../common/components/empty_value");
var _links = require("../../../../common/components/links");
var _paginated_table = require("../../../components/paginated_table");
var i18n = _interopRequireWildcard(require("./translations"));
var _helpers = require("../../../../common/components/tables/helpers");
var _model = require("../../store/model");
var _use_selector = require("../../../../common/hooks/use_selector");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const tableType = _store.hostsModel.HostsTableType.uncommonProcesses;
const rowItems = [{
  text: i18n.ROWS_5,
  numberOfRow: 5
}, {
  text: i18n.ROWS_10,
  numberOfRow: 10
}];
const getArgs = args => {
  if (args != null && args.length !== 0) {
    return args.join(' ');
  } else {
    return null;
  }
};
exports.getArgs = getArgs;
const UncommonProcessTableComponent = /*#__PURE__*/_react.default.memo(({
  data,
  fakeTotalCount,
  id,
  isInspect,
  loading,
  loadPage,
  totalCount,
  setQuerySkip,
  showMorePagesIndicator,
  type
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const getUncommonProcessesSelector = (0, _react.useMemo)(() => _store.hostsSelectors.uncommonProcessesSelector(), []);
  const {
    activePage,
    limit
  } = (0, _use_selector.useDeepEqualSelector)(state => getUncommonProcessesSelector(state, type));
  const updateLimitPagination = (0, _react.useCallback)(newLimit => dispatch(_store.hostsActions.updateTableLimit({
    hostsType: type,
    limit: newLimit,
    tableType
  })), [type, dispatch]);
  const updateActivePage = (0, _react.useCallback)(newPage => dispatch(_store.hostsActions.updateTableActivePage({
    activePage: newPage,
    hostsType: type,
    tableType
  })), [type, dispatch]);
  const columns = (0, _react.useMemo)(() => getUncommonColumnsCurated(type), [type]);
  return /*#__PURE__*/_react.default.createElement(_paginated_table.PaginatedTable, {
    activePage: activePage,
    columns: columns,
    dataTestSubj: `table-${tableType}`,
    headerCount: totalCount,
    headerTitle: i18n.UNCOMMON_PROCESSES,
    headerUnit: i18n.UNIT(totalCount),
    id: id,
    isInspect: isInspect,
    itemsPerRow: rowItems,
    limit: limit,
    loading: loading,
    loadPage: loadPage,
    pageOfItems: data,
    setQuerySkip: setQuerySkip,
    showMorePagesIndicator: showMorePagesIndicator,
    totalCount: fakeTotalCount,
    updateLimitPagination: updateLimitPagination,
    updateActivePage: updateActivePage
  });
});
UncommonProcessTableComponent.displayName = 'UncommonProcessTableComponent';
const UncommonProcessTable = /*#__PURE__*/_react.default.memo(UncommonProcessTableComponent);
exports.UncommonProcessTable = UncommonProcessTable;
UncommonProcessTable.displayName = 'UncommonProcessTable';
const getUncommonColumns = () => [{
  name: i18n.NAME,
  truncateText: false,
  mobileOptions: {
    show: true
  },
  width: '20%',
  render: ({
    node
  }) => (0, _helpers.getRowItemsWithActions)({
    values: node.process.name,
    fieldName: 'process.name',
    fieldType: 'keyword',
    aggregatable: true,
    idPrefix: `uncommon-process-table-${node._id}-processName`
  })
}, {
  align: 'right',
  name: i18n.NUMBER_OF_HOSTS,
  truncateText: false,
  mobileOptions: {
    show: true
  },
  render: ({
    node
  }) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, node.hosts != null ? node.hosts.length : (0, _empty_value.getEmptyValue)()),
  width: '8%'
}, {
  align: 'right',
  name: i18n.NUMBER_OF_INSTANCES,
  truncateText: false,
  mobileOptions: {
    show: true
  },
  render: ({
    node
  }) => (0, _empty_value.defaultToEmptyTag)(node.instances),
  width: '8%'
}, {
  name: i18n.HOSTS,
  truncateText: false,
  mobileOptions: {
    show: true
  },
  width: '25%',
  render: ({
    node
  }) => (0, _helpers.getRowItemsWithActions)({
    values: getHostNames(node.hosts),
    fieldName: 'host.name',
    fieldType: 'keyword',
    aggregatable: true,
    idPrefix: `uncommon-process-table-${node._id}-processHost`,
    render: item => /*#__PURE__*/_react.default.createElement(_links.HostDetailsLink, {
      hostName: item
    })
  })
}, {
  name: i18n.LAST_COMMAND,
  truncateText: false,
  mobileOptions: {
    show: true
  },
  width: '25%',
  render: ({
    node
  }) => (0, _helpers.getRowItemsWithActions)({
    values: node.process != null ? node.process.args : null,
    fieldName: 'process.args',
    fieldType: 'keyword',
    aggregatable: true,
    idPrefix: `uncommon-process-table-${node._id}-processArgs`,
    render: item => /*#__PURE__*/_react.default.createElement(_links.HostDetailsLink, {
      hostName: item
    }),
    displayCount: 1
  })
}, {
  name: i18n.LAST_USER,
  truncateText: false,
  mobileOptions: {
    show: true
  },
  render: ({
    node
  }) => (0, _helpers.getRowItemsWithActions)({
    values: node.user != null ? node.user.name : null,
    fieldName: 'user.name',
    fieldType: 'keyword',
    aggregatable: true,
    idPrefix: `uncommon-process-table-${node._id}-processUser`
  })
}];
const getHostNames = hosts => {
  if (hosts != null) {
    return hosts.filter(host => host.name != null && host.name[0] != null).map(host => host.name != null && host.name[0] != null ? host.name[0] : '');
  } else {
    return [];
  }
};
exports.getHostNames = getHostNames;
const getUncommonColumnsCurated = pageType => {
  const columns = getUncommonColumns();
  if (pageType === _model.HostsType.details) {
    return [i18n.HOSTS, i18n.NUMBER_OF_HOSTS].reduce((acc, name) => {
      acc.splice(acc.findIndex(column => column.name === name), 1);
      return acc;
    }, columns);
  } else {
    return columns;
  }
};
exports.getUncommonColumnsCurated = getUncommonColumnsCurated;