"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RiskyHosts = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _uiTheme = require("@kbn/ui-theme");
var _risk_information = require("../../../../components/risk_score/risk_information");
var _inspect = require("../../../../../common/components/inspect");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_inspect_query = require("../../../../../common/hooks/use_inspect_query");
var _use_error_toast = require("../../../../../common/hooks/use_error_toast");
var _hover_visibility_container = require("../../../../../common/components/hover_visibility_container");
var _search_strategy = require("../../../../../../common/search_strategy");
var _common = require("../../../../components/risk_score/severity/common");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const KpiBaseComponentLoader = () => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  justifyContent: "center",
  alignItems: "center",
  "data-test-subj": "KpiLoader"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
  size: "xl"
})));
const QUERY_ID = 'hostsKpiRiskyHostsQuery';
const HostCount = (0, _styledComponents.default)(_eui.EuiText)`
  font-weight: bold;
`;
HostCount.displayName = 'HostCount';
const StatusTitle = (0, _styledComponents.default)(_eui.EuiTitle)`
  text-transform: lowercase;
`;
const RiskScoreContainer = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  min-width: 80px;
`;

/**
 * FUTURE ENGINEER: This is a host risk card for the host page.
 * Due to not being able to apply KQL,
 * we decided not to go forward with this for 8.1
 * saving the code for future implementation
 */
const RiskyHostsComponent = ({
  error,
  loading,
  data
}) => {
  var _data$kpiRiskScore$Cr, _data$kpiRiskScore$Hi;
  (0, _use_inspect_query.useInspectQuery)(QUERY_ID, loading, data);
  (0, _use_error_toast.useErrorToast)(i18n.ERROR_TITLE, error);
  if (loading) {
    return /*#__PURE__*/_react.default.createElement(KpiBaseComponentLoader, null);
  }
  const criticalRiskCount = (_data$kpiRiskScore$Cr = data === null || data === void 0 ? void 0 : data.kpiRiskScore.Critical) !== null && _data$kpiRiskScore$Cr !== void 0 ? _data$kpiRiskScore$Cr : 0;
  const hightlRiskCount = (_data$kpiRiskScore$Hi = data === null || data === void 0 ? void 0 : data.kpiRiskScore.High) !== null && _data$kpiRiskScore$Hi !== void 0 ? _data$kpiRiskScore$Hi : 0;
  const totalCount = criticalRiskCount + hightlRiskCount;
  return /*#__PURE__*/_react.default.createElement(_hover_visibility_container.HoverVisibilityContainer, {
    targetClassNames: [_inspect.BUTTON_CLASS, _risk_information.HOST_RISK_INFO_BUTTON_CLASS]
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    "data-test-subj": "risky-hosts"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: 'none'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxxs"
  }, /*#__PURE__*/_react.default.createElement("h6", null, i18n.RISKY_HOSTS_TITLE))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_risk_information.RiskInformationButtonIcon, {
    riskEntity: _search_strategy.RiskScoreEntity.host
  })), (data === null || data === void 0 ? void 0 : data.inspect) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_inspect.InspectButton, {
    queryId: QUERY_ID,
    title: i18n.INSPECT_RISKY_HOSTS
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "m",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "warning",
    color: _uiTheme.euiLightVars.euiColorDarkestShade,
    size: "l"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(StatusTitle, {
    className: "eui-textTruncate",
    "data-test-subj": "riskyHostsTotal"
  }, /*#__PURE__*/_react.default.createElement("p", null, i18n.RISKY_HOSTS_DESCRIPTION(totalCount, totalCount.toLocaleString()))))))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "l",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(RiskScoreContainer, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_common.RiskScore, {
    severity: _search_strategy.RiskSeverity.critical
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(HostCount, {
    size: "m",
    "data-test-subj": "riskyHostsCriticalQuantity"
  }, i18n.HOSTS_COUNT(criticalRiskCount))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(RiskScoreContainer, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_common.RiskScore, {
    severity: _search_strategy.RiskSeverity.high
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(HostCount, {
    size: "m",
    "data-test-subj": "riskyHostsHighQuantity"
  }, i18n.HOSTS_COUNT(hightlRiskCount))))))));
};
const RiskyHosts = /*#__PURE__*/_react.default.memo(RiskyHostsComponent);
exports.RiskyHosts = RiskyHosts;