"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VIEW_HOSTS_BY_SEVERITY = exports.HOST_RISK_TOOLTIP = exports.HOST_RISK_TITLE = exports.HOST_RISK_TABLE_TOOLTIP = exports.HOST_RISK_SCORE = exports.HOST_RISK = exports.HOST_NAME = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HOST_NAME = _i18n.i18n.translate('xpack.securitySolution.hostsRiskTable.hostNameTitle', {
  defaultMessage: 'Host Name'
});
exports.HOST_NAME = HOST_NAME;
const HOST_RISK_SCORE = _i18n.i18n.translate('xpack.securitySolution.hostsRiskTable.hostRiskScoreTitle', {
  defaultMessage: 'Host risk score'
});
exports.HOST_RISK_SCORE = HOST_RISK_SCORE;
const HOST_RISK = _i18n.i18n.translate('xpack.securitySolution.hostsRiskTable.riskTitle', {
  defaultMessage: 'Host risk classification'
});
exports.HOST_RISK = HOST_RISK;
const HOST_RISK_TOOLTIP = _i18n.i18n.translate('xpack.securitySolution.hostsRiskTable.hostRiskToolTip', {
  defaultMessage: 'Host risk classification is determined by host risk score. Hosts classified as Critical or High are indicated as risky.'
});
exports.HOST_RISK_TOOLTIP = HOST_RISK_TOOLTIP;
const HOST_RISK_TITLE = _i18n.i18n.translate('xpack.securitySolution.hostsRiskTable.hostRiskTitle', {
  defaultMessage: 'Host risk'
});
exports.HOST_RISK_TITLE = HOST_RISK_TITLE;
const HOST_RISK_TABLE_TOOLTIP = _i18n.i18n.translate('xpack.securitySolution.hostsRiskTable.hostsTableTooltip', {
  defaultMessage: 'The host risk table is not affected by the KQL time range. This table shows the latest recorded risk score for each host.'
});
exports.HOST_RISK_TABLE_TOOLTIP = HOST_RISK_TABLE_TOOLTIP;
const VIEW_HOSTS_BY_SEVERITY = severity => _i18n.i18n.translate('xpack.securitySolution.hostsRiskTable.filteredHostsTitle', {
  values: {
    severity
  },
  defaultMessage: 'View {severity} risk hosts'
});
exports.VIEW_HOSTS_BY_SEVERITY = VIEW_HOSTS_BY_SEVERITY;