"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.rowItems = exports.HostRiskScoreTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _eui = require("@elastic/eui");
var _paginated_table = require("../../../components/paginated_table");
var _use_selector = require("../../../../common/hooks/use_selector");
var _store = require("../../store");
var _columns = require("./columns");
var _search_strategy = require("../../../../../common/search_strategy");
var i18n = _interopRequireWildcard(require("../hosts_table/translations"));
var i18nHosts = _interopRequireWildcard(require("./translations"));
var _severity_badges = require("../../../components/risk_score/severity/severity_badges");
var _severity_bar = require("../../../components/risk_score/severity/severity_bar");
var _severity_filter_group = require("../../../components/risk_score/severity/severity_filter_group");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const rowItems = [{
  text: i18n.ROWS_5,
  numberOfRow: 5
}, {
  text: i18n.ROWS_10,
  numberOfRow: 10
}];
exports.rowItems = rowItems;
const tableType = _store.hostsModel.HostsTableType.risk;
const HostRiskScoreTableComponent = ({
  data,
  id,
  isInspect,
  loading,
  loadPage,
  setQuerySkip,
  severityCount,
  totalCount,
  type
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const getHostRiskScoreSelector = (0, _react.useMemo)(() => _store.hostsSelectors.hostRiskScoreSelector(), []);
  const {
    activePage,
    limit,
    sort
  } = (0, _use_selector.useDeepEqualSelector)(state => getHostRiskScoreSelector(state, _store.hostsModel.HostsType.page));
  const updateLimitPagination = (0, _react.useCallback)(newLimit => dispatch(_store.hostsActions.updateTableLimit({
    hostsType: type,
    limit: newLimit,
    tableType
  })), [type, dispatch]);
  const updateActivePage = (0, _react.useCallback)(newPage => dispatch(_store.hostsActions.updateTableActivePage({
    activePage: newPage,
    hostsType: type,
    tableType
  })), [type, dispatch]);
  const onSort = (0, _react.useCallback)(criteria => {
    if (criteria.sort != null) {
      const newSort = criteria.sort;
      if (newSort.direction !== sort.direction || newSort.field !== sort.field) {
        dispatch(_store.hostsActions.updateHostRiskScoreSort({
          sort: newSort,
          hostsType: type
        }));
      }
    }
  }, [dispatch, sort, type]);
  const dispatchSeverityUpdate = (0, _react.useCallback)(s => {
    dispatch(_store.hostsActions.updateHostRiskScoreSeverityFilter({
      severitySelection: [s],
      hostsType: type
    }));
  }, [dispatch, type]);
  const columns = (0, _react.useMemo)(() => (0, _columns.getHostRiskScoreColumns)({
    dispatchSeverityUpdate
  }), [dispatchSeverityUpdate]);
  const risk = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_severity_badges.SeverityBadges, {
    severityCount: severityCount
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_severity_bar.SeverityBar, {
    severityCount: severityCount
  })));
  const getHostRiskScoreFilterQuerySelector = (0, _react.useMemo)(() => _store.hostsSelectors.hostRiskScoreSeverityFilterSelector(), []);
  const severitySelectionRedux = (0, _use_selector.useDeepEqualSelector)(state => getHostRiskScoreFilterQuerySelector(state, type));
  const onSelect = (0, _react.useCallback)(newSelection => {
    dispatch(_store.hostsActions.updateHostRiskScoreSeverityFilter({
      severitySelection: newSelection,
      hostsType: type
    }));
  }, [dispatch, type]);
  return /*#__PURE__*/_react.default.createElement(_paginated_table.PaginatedTable, {
    activePage: activePage,
    columns: columns,
    dataTestSubj: `table-${tableType}`,
    headerCount: totalCount,
    headerFilters: /*#__PURE__*/_react.default.createElement(_severity_filter_group.SeverityFilterGroup, {
      selectedSeverities: severitySelectionRedux,
      severityCount: severityCount,
      onSelect: onSelect,
      riskEntity: _search_strategy.RiskScoreEntity.host
    }),
    headerSupplement: risk,
    headerTitle: i18nHosts.HOST_RISK_TITLE,
    headerUnit: i18n.UNIT(totalCount),
    headerTooltip: i18nHosts.HOST_RISK_TABLE_TOOLTIP,
    id: id,
    isInspect: isInspect,
    itemsPerRow: rowItems,
    limit: limit,
    loading: loading,
    loadPage: loadPage,
    onChange: onSort,
    pageOfItems: data,
    setQuerySkip: setQuerySkip,
    showMorePagesIndicator: false,
    sorting: sort,
    split: true,
    stackHeader: true,
    totalCount: totalCount,
    updateLimitPagination: updateLimitPagination,
    updateActivePage: updateActivePage
  });
};
HostRiskScoreTableComponent.displayName = 'HostRiskScoreTableComponent';
const HostRiskScoreTable = /*#__PURE__*/_react.default.memo(HostRiskScoreTableComponent);
exports.HostRiskScoreTable = HostRiskScoreTable;
HostRiskScoreTable.displayName = 'HostRiskScoreTable';