"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RiskScoreUpgradeButton = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _use_space_id = require("../../../../common/hooks/use_space_id");
var _kibana = require("../../../../common/lib/kibana");
var _utils = require("./utils");
var _search_strategy = require("../../../../../common/search_strategy");
var _use_risk_score_toast_content = require("./use_risk_score_toast_content");
var _use_fetch = require("../../../../common/hooks/use_fetch");
var _risk_score_doc_link = require("./risk_score_doc_link");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RiskScoreUpgradeButtonComponent = ({
  disabled,
  refetch,
  riskScoreEntity,
  timerange,
  title
}) => {
  const spaceId = (0, _use_space_id.useSpaceId)();
  const {
    http,
    notifications,
    theme,
    dashboard
  } = (0, _kibana.useKibana)().services;
  const {
    renderDocLink,
    renderDashboardLink
  } = (0, _use_risk_score_toast_content.useRiskScoreToastContent)(riskScoreEntity);
  const {
    fetch,
    isLoading
  } = (0, _use_fetch.useFetch)(_use_fetch.REQUEST_NAMES.UPGRADE_RISK_SCORE, riskScoreEntity === _search_strategy.RiskScoreEntity.user ? _utils.upgradeUserRiskScoreModule : _utils.upgradeHostRiskScoreModule);
  const [isModalVisible, setIsModalVisible] = (0, _react.useState)(false);
  const closeModal = (0, _react.useCallback)(() => setIsModalVisible(false), []);
  const showModal = (0, _react.useCallback)(() => setIsModalVisible(true), []);
  const upgradeRiskScore = (0, _react.useCallback)(async () => {
    closeModal();
    fetch({
      http,
      notifications,
      spaceId,
      timerange,
      refetch,
      renderDashboardLink,
      renderDocLink,
      riskScoreEntity,
      theme,
      dashboard
    });
  }, [closeModal, fetch, http, notifications, spaceId, timerange, refetch, renderDashboardLink, renderDocLink, riskScoreEntity, theme, dashboard]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "primary",
    "data-test-subj": `${riskScoreEntity}-risk-score-upgrade`,
    disabled: disabled,
    fill: true,
    isLoading: isLoading,
    onClick: showModal
  }, title), isModalVisible && /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "data-test-subj": `${riskScoreEntity}-risk-score-upgrade-confirmation-modal`,
    title: title,
    onCancel: closeModal,
    onConfirm: upgradeRiskScore,
    cancelButtonText: /*#__PURE__*/_react.default.createElement(_risk_score_doc_link.RiskScoreDocLink, {
      riskScoreEntity: riskScoreEntity,
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.riskScore.upgradeConfirmation.cancel",
        defaultMessage: "Preserve data"
      })
    }),
    confirmButtonText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      "data-test-subj": `${riskScoreEntity}-risk-score-upgrade-confirmation-button`,
      id: "xpack.securitySolution.riskScore.upgradeConfirmation.confirm",
      defaultMessage: "Erase data and Upgrade"
    }),
    buttonColor: "danger",
    defaultFocusedButton: "confirm"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.riskScore.upgradeConfirmation.content",
    defaultMessage: "The upgrade will delete existing risk scores from your environment. You may preserve existing risk data before upgrading the Risk Score package. Do you wish to upgrade?"
  })));
};
const RiskScoreUpgradeButton = /*#__PURE__*/_react.default.memo(RiskScoreUpgradeButtonComponent);
exports.RiskScoreUpgradeButton = RiskScoreUpgradeButton;
RiskScoreUpgradeButton.displayName = 'RiskScoreUpgradeButton';