"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RiskDetailsTabBody = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _constants = require("../constants");
var _enable_risk_score = require("../enable_risk_score");
var _use_selector = require("../../../../common/hooks/use_selector");
var _store = require("../../../hosts/store");
var _store2 = require("../../../users/store");
var _risk_information = require("../risk_information");
var i18n = _interopRequireWildcard(require("./translations"));
var _manage_query = require("../../../../common/components/page/manage_query");
var _risk_score_over_time = require("../risk_score_over_time");
var _top_risk_score_contributors = require("../top_risk_score_contributors");
var _query_toggle = require("../../../../common/containers/query_toggle");
var _risk_score = require("../../../containers/risk_score");
var _search_strategy = require("../../../../../common/search_strategy");
var _use_dashboard_button_href = require("../../../../common/hooks/use_dashboard_button_href");
var _risk_score_no_data_detected = require("../risk_score_onboarding/risk_score_no_data_detected");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StyledEuiFlexGroup = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  margin-top: ${({
  theme
}) => theme.eui.euiSizeL};
`;
const getDashboardTitle = riskEntity => riskEntity === _search_strategy.RiskScoreEntity.host ? _constants.RISKY_HOSTS_DASHBOARD_TITLE : _constants.RISKY_USERS_DASHBOARD_TITLE;
const RiskDetailsTabBodyComponent = ({
  entityName,
  startDate,
  endDate,
  setQuery,
  deleteQuery,
  riskEntity
}) => {
  const queryId = (0, _react.useMemo)(() => riskEntity === _search_strategy.RiskScoreEntity.host ? _risk_score.HostRiskScoreQueryId.HOST_DETAILS_RISK_SCORE : _risk_score.UserRiskScoreQueryId.USER_DETAILS_RISK_SCORE, [riskEntity]);
  const severitySelectionRedux = (0, _use_selector.useDeepEqualSelector)(state => riskEntity === _search_strategy.RiskScoreEntity.host ? _store.hostsSelectors.hostRiskScoreSeverityFilterSelector()(state, _store.hostsModel.HostsType.details) : _store2.usersSelectors.userRiskScoreSeverityFilterSelector()(state));
  const {
    buttonHref
  } = (0, _use_dashboard_button_href.useDashboardButtonHref)({
    to: endDate,
    from: startDate,
    title: getDashboardTitle(riskEntity)
  });
  const timerange = (0, _react.useMemo)(() => ({
    from: startDate,
    to: endDate
  }), [startDate, endDate]);
  const {
    toggleStatus: overTimeToggleStatus,
    setToggleStatus: setOverTimeToggleStatus
  } = (0, _query_toggle.useQueryToggle)(`${queryId} overTime`);
  const {
    toggleStatus: contributorsToggleStatus,
    setToggleStatus: setContributorsToggleStatus
  } = (0, _query_toggle.useQueryToggle)(`${queryId} contributors`);
  const filterQuery = (0, _react.useMemo)(() => entityName ? (0, _search_strategy.buildEntityNameFilter)([entityName], riskEntity) : {}, [entityName, riskEntity]);
  const {
    data,
    loading,
    refetch,
    inspect,
    isDeprecated,
    isModuleEnabled
  } = (0, _risk_score.useRiskScore)({
    filterQuery,
    onlyLatest: false,
    riskEntity,
    skip: !overTimeToggleStatus && !contributorsToggleStatus,
    timerange
  });
  const rules = (0, _react.useMemo)(() => {
    const lastRiskItem = data && data.length > 0 ? data[data.length - 1] : null;
    if (lastRiskItem) {
      return riskEntity === _search_strategy.RiskScoreEntity.host ? lastRiskItem.host.risk.rule_risks : lastRiskItem.user.risk.rule_risks;
    }
    return [];
  }, [data, riskEntity]);
  (0, _manage_query.useQueryInspector)({
    queryId,
    loading,
    refetch,
    setQuery,
    deleteQuery,
    inspect
  });
  const toggleContributorsQuery = (0, _react.useCallback)(status => {
    setContributorsToggleStatus(status);
  }, [setContributorsToggleStatus]);
  const toggleOverTimeQuery = (0, _react.useCallback)(status => {
    setOverTimeToggleStatus(status);
  }, [setOverTimeToggleStatus]);
  const status = {
    isDisabled: !isModuleEnabled && !loading,
    isDeprecated: isDeprecated && !loading
  };
  if (status.isDisabled || status.isDeprecated) {
    return /*#__PURE__*/_react.default.createElement(_enable_risk_score.EnableRiskScore, (0, _extends2.default)({}, status, {
      entityType: riskEntity,
      refetch: refetch,
      timerange: timerange
    }));
  }
  if (isModuleEnabled && severitySelectionRedux.length === 0 && data && data.length === 0) {
    return /*#__PURE__*/_react.default.createElement(_risk_score_no_data_detected.RiskScoresNoDataDetected, {
      entityType: riskEntity,
      refetch: refetch
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2
  }, /*#__PURE__*/_react.default.createElement(_risk_score_over_time.RiskScoreOverTime, {
    from: startDate,
    loading: loading,
    queryId: queryId,
    riskEntity: riskEntity,
    riskScore: data,
    title: i18n.RISK_SCORE_OVER_TIME(riskEntity),
    to: endDate,
    toggleQuery: toggleOverTimeQuery,
    toggleStatus: overTimeToggleStatus
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_top_risk_score_contributors.TopRiskScoreContributors, {
    loading: loading,
    queryId: queryId,
    toggleStatus: contributorsToggleStatus,
    toggleQuery: toggleContributorsQuery,
    rules: rules
  }))), /*#__PURE__*/_react.default.createElement(StyledEuiFlexGroup, {
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    href: buttonHref,
    isDisabled: !buttonHref,
    "data-test-subj": `risky-${riskEntity}s-view-dashboard-button`,
    target: "_blank"
  }, i18n.VIEW_DASHBOARD_BUTTON)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_risk_information.RiskInformationButtonEmpty, {
    riskEntity: riskEntity
  }))));
};
RiskDetailsTabBodyComponent.displayName = 'RiskDetailsTabBodyComponent';
const RiskDetailsTabBody = /*#__PURE__*/_react.default.memo(RiskDetailsTabBodyComponent);
exports.RiskDetailsTabBody = RiskDetailsTabBody;
RiskDetailsTabBody.displayName = 'RiskDetailsTabBody';