"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.rowItems = exports.histogramConfigs = exports.getUsersPageAuthenticationColumns = exports.getUserDetailsAuthenticationColumns = exports.getHostsPageAuthenticationColumns = exports.getHostDetailsAuthenticationColumns = exports.authenticationsStackByOptions = exports.authenticationsMatrixDataMappingFields = exports.ChartColors = void 0;
var _fp = require("lodash/fp");
var _react = _interopRequireDefault(require("react"));
var _empty_value = require("../../../common/components/empty_value");
var _formatted_date = require("../../../common/components/formatted_date");
var _helpers = require("../../../common/components/tables/helpers");
var i18n = _interopRequireWildcard(require("./translations"));
var _links = require("../../../common/components/links");
var _search_strategy = require("../../../../common/search_strategy");
var _authentication = require("../../../common/components/visualization_actions/lens_attributes/common/authentication");
var _authenticationsStack;
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
const getHostDetailsAuthenticationColumns = () => [USER_COLUMN, SUCCESS_COLUMN, FAILURES_COLUMN, LAST_SUCCESSFUL_TIME_COLUMN, LAST_SUCCESSFUL_SOURCE_COLUMN, LAST_FAILED_TIME_COLUMN, LAST_FAILED_SOURCE_COLUMN];
exports.getHostDetailsAuthenticationColumns = getHostDetailsAuthenticationColumns;
const getHostsPageAuthenticationColumns = () => [USER_COLUMN, SUCCESS_COLUMN, FAILURES_COLUMN, LAST_SUCCESSFUL_TIME_COLUMN, LAST_SUCCESSFUL_SOURCE_COLUMN, LAST_SUCCESSFUL_DESTINATION_COLUMN, LAST_FAILED_TIME_COLUMN, LAST_FAILED_SOURCE_COLUMN, LAST_FAILED_DESTINATION_COLUMN];
exports.getHostsPageAuthenticationColumns = getHostsPageAuthenticationColumns;
const getUsersPageAuthenticationColumns = () => getHostsPageAuthenticationColumns();
exports.getUsersPageAuthenticationColumns = getUsersPageAuthenticationColumns;
const getUserDetailsAuthenticationColumns = () => [HOST_COLUMN, SUCCESS_COLUMN, FAILURES_COLUMN, LAST_SUCCESSFUL_TIME_COLUMN, LAST_SUCCESSFUL_SOURCE_COLUMN, LAST_FAILED_TIME_COLUMN, LAST_FAILED_SOURCE_COLUMN];
exports.getUserDetailsAuthenticationColumns = getUserDetailsAuthenticationColumns;
const rowItems = [{
  text: i18n.ROWS_5,
  numberOfRow: 5
}, {
  text: i18n.ROWS_10,
  numberOfRow: 10
}];
exports.rowItems = rowItems;
const FAILURES_COLUMN = {
  name: i18n.FAILURES,
  field: 'node.failures',
  truncateText: false,
  mobileOptions: {
    show: true
  },
  width: '8%'
};
const LAST_SUCCESSFUL_TIME_COLUMN = {
  name: i18n.LAST_SUCCESSFUL_TIME,
  truncateText: false,
  mobileOptions: {
    show: true
  },
  render: ({
    node
  }) => {
    var _node$lastSuccess, _node$lastSuccess2;
    return (0, _fp.has)('lastSuccess.timestamp', node) && ((_node$lastSuccess = node.lastSuccess) === null || _node$lastSuccess === void 0 ? void 0 : _node$lastSuccess.timestamp) != null ? /*#__PURE__*/_react.default.createElement(_formatted_date.FormattedRelativePreferenceDate, {
      value: (_node$lastSuccess2 = node.lastSuccess) === null || _node$lastSuccess2 === void 0 ? void 0 : _node$lastSuccess2.timestamp
    }) : (0, _empty_value.getEmptyTagValue)();
  }
};
const LAST_SUCCESSFUL_SOURCE_COLUMN = {
  name: i18n.LAST_SUCCESSFUL_SOURCE,
  truncateText: false,
  mobileOptions: {
    show: true
  },
  render: ({
    node
  }) => {
    var _node$lastSuccess3, _node$lastSuccess3$so;
    return (0, _helpers.getRowItemsWithActions)({
      values: ((_node$lastSuccess3 = node.lastSuccess) === null || _node$lastSuccess3 === void 0 ? void 0 : (_node$lastSuccess3$so = _node$lastSuccess3.source) === null || _node$lastSuccess3$so === void 0 ? void 0 : _node$lastSuccess3$so.ip) || null,
      fieldName: 'source.ip',
      fieldType: 'ip',
      aggregatable: true,
      idPrefix: `authentications-table-${node._id}-lastSuccessSource`,
      render: item => /*#__PURE__*/_react.default.createElement(_links.NetworkDetailsLink, {
        ip: item
      })
    });
  }
};
const LAST_SUCCESSFUL_DESTINATION_COLUMN = {
  name: i18n.LAST_SUCCESSFUL_DESTINATION,
  truncateText: false,
  mobileOptions: {
    show: true
  },
  render: ({
    node
  }) => {
    var _node$lastSuccess$hos, _node$lastSuccess4, _node$lastSuccess4$ho;
    return (0, _helpers.getRowItemsWithActions)({
      values: (_node$lastSuccess$hos = (_node$lastSuccess4 = node.lastSuccess) === null || _node$lastSuccess4 === void 0 ? void 0 : (_node$lastSuccess4$ho = _node$lastSuccess4.host) === null || _node$lastSuccess4$ho === void 0 ? void 0 : _node$lastSuccess4$ho.name) !== null && _node$lastSuccess$hos !== void 0 ? _node$lastSuccess$hos : null,
      fieldName: 'host.name',
      fieldType: 'keyword',
      aggregatable: true,
      idPrefix: `authentications-table-${node._id}-lastSuccessfulDestination`,
      render: item => /*#__PURE__*/_react.default.createElement(_links.HostDetailsLink, {
        hostName: item
      })
    });
  }
};
const LAST_FAILED_TIME_COLUMN = {
  name: i18n.LAST_FAILED_TIME,
  truncateText: false,
  mobileOptions: {
    show: true
  },
  render: ({
    node
  }) => {
    var _node$lastFailure, _node$lastFailure2;
    return (0, _fp.has)('lastFailure.timestamp', node) && ((_node$lastFailure = node.lastFailure) === null || _node$lastFailure === void 0 ? void 0 : _node$lastFailure.timestamp) != null ? /*#__PURE__*/_react.default.createElement(_formatted_date.FormattedRelativePreferenceDate, {
      value: (_node$lastFailure2 = node.lastFailure) === null || _node$lastFailure2 === void 0 ? void 0 : _node$lastFailure2.timestamp
    }) : (0, _empty_value.getEmptyTagValue)();
  }
};
const LAST_FAILED_SOURCE_COLUMN = {
  name: i18n.LAST_FAILED_SOURCE,
  truncateText: false,
  mobileOptions: {
    show: true
  },
  render: ({
    node
  }) => {
    var _node$lastFailure3, _node$lastFailure3$so;
    return (0, _helpers.getRowItemsWithActions)({
      values: ((_node$lastFailure3 = node.lastFailure) === null || _node$lastFailure3 === void 0 ? void 0 : (_node$lastFailure3$so = _node$lastFailure3.source) === null || _node$lastFailure3$so === void 0 ? void 0 : _node$lastFailure3$so.ip) || null,
      fieldName: 'source.ip',
      fieldType: 'ip',
      aggregatable: true,
      idPrefix: `authentications-table-${node._id}-lastFailureSource`,
      render: item => /*#__PURE__*/_react.default.createElement(_links.NetworkDetailsLink, {
        ip: item
      })
    });
  }
};
const LAST_FAILED_DESTINATION_COLUMN = {
  name: i18n.LAST_FAILED_DESTINATION,
  truncateText: false,
  mobileOptions: {
    show: true
  },
  render: ({
    node
  }) => {
    var _node$lastFailure4, _node$lastFailure4$ho;
    return (0, _helpers.getRowItemsWithActions)({
      values: ((_node$lastFailure4 = node.lastFailure) === null || _node$lastFailure4 === void 0 ? void 0 : (_node$lastFailure4$ho = _node$lastFailure4.host) === null || _node$lastFailure4$ho === void 0 ? void 0 : _node$lastFailure4$ho.name) || null,
      fieldName: 'host.name',
      fieldType: 'keyword',
      aggregatable: true,
      idPrefix: `authentications-table-${node._id}-lastFailureDestination`,
      render: item => /*#__PURE__*/_react.default.createElement(_links.HostDetailsLink, {
        hostName: item
      })
    });
  }
};
const USER_COLUMN = {
  name: i18n.USER,
  truncateText: false,
  mobileOptions: {
    show: true
  },
  render: ({
    node
  }) => (0, _helpers.getRowItemsWithActions)({
    values: node.stackedValue,
    fieldName: 'user.name',
    idPrefix: `authentications-table-${node._id}-userName`,
    fieldType: 'keyword',
    aggregatable: true,
    render: item => /*#__PURE__*/_react.default.createElement(_links.UserDetailsLink, {
      userName: item
    })
  })
};
const HOST_COLUMN = {
  name: i18n.HOST,
  truncateText: false,
  mobileOptions: {
    show: true
  },
  render: ({
    node
  }) => (0, _helpers.getRowItemsWithActions)({
    values: node.stackedValue,
    fieldName: 'host.name',
    idPrefix: `authentications-table-${node._id}-hostName`,
    fieldType: 'keyword',
    aggregatable: true,
    render: item => /*#__PURE__*/_react.default.createElement(_links.HostDetailsLink, {
      hostName: item
    })
  })
};
const SUCCESS_COLUMN = {
  name: i18n.SUCCESSES,
  field: 'node.successes',
  truncateText: false,
  mobileOptions: {
    show: true
  },
  width: '8%'
};
const authenticationsStackByOptions = [{
  text: 'event.outcome',
  value: 'event.outcome'
}];
exports.authenticationsStackByOptions = authenticationsStackByOptions;
const DEFAULT_STACK_BY = 'event.outcome';
var AuthenticationsMatrixDataGroup;
(function (AuthenticationsMatrixDataGroup) {
  AuthenticationsMatrixDataGroup["authenticationsSuccess"] = "success";
  AuthenticationsMatrixDataGroup["authenticationsFailure"] = "failure";
})(AuthenticationsMatrixDataGroup || (AuthenticationsMatrixDataGroup = {}));
let ChartColors;
exports.ChartColors = ChartColors;
(function (ChartColors) {
  ChartColors["authenticationsSuccess"] = "#54B399";
  ChartColors["authenticationsFailure"] = "#E7664C";
})(ChartColors || (exports.ChartColors = ChartColors = {}));
const authenticationsMatrixDataMappingFields = {
  [AuthenticationsMatrixDataGroup.authenticationsSuccess]: {
    key: AuthenticationsMatrixDataGroup.authenticationsSuccess,
    value: null,
    color: ChartColors.authenticationsSuccess
  },
  [AuthenticationsMatrixDataGroup.authenticationsFailure]: {
    key: AuthenticationsMatrixDataGroup.authenticationsFailure,
    value: null,
    color: ChartColors.authenticationsFailure
  }
};
exports.authenticationsMatrixDataMappingFields = authenticationsMatrixDataMappingFields;
const histogramConfigs = {
  defaultStackByOption: (_authenticationsStack = authenticationsStackByOptions.find(o => o.text === DEFAULT_STACK_BY)) !== null && _authenticationsStack !== void 0 ? _authenticationsStack : authenticationsStackByOptions[0],
  errorMessage: i18n.ERROR_FETCHING_AUTHENTICATIONS_DATA,
  histogramType: _search_strategy.MatrixHistogramType.authentications,
  mapping: authenticationsMatrixDataMappingFields,
  stackByOptions: authenticationsStackByOptions,
  title: i18n.NAVIGATION_AUTHENTICATIONS_TITLE,
  lensAttributes: _authentication.authenticationLensAttributes
};
exports.histogramConfigs = histogramConfigs;