"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.routes = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _public = require("@kbn/usage-collection-plugin/public");
var i18n = _interopRequireWildcard(require("./translations"));
var _constants = require("../../common/constants");
var _pages = require("./pages");
var _spy_routes = require("../common/utils/route/spy_routes");
var _ = require("../app/404");
var _use_readonly_header = require("../use_readonly_header");
var _plugin_template_wrapper = require("../common/components/plugin_template_wrapper");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ExceptionsRoutes = () => /*#__PURE__*/_react.default.createElement(_plugin_template_wrapper.PluginTemplateWrapper, null, /*#__PURE__*/_react.default.createElement(_public.TrackApplicationView, {
  viewId: _constants.SecurityPageName.exceptions
}, /*#__PURE__*/_react.default.createElement(_pages.SharedLists, null), /*#__PURE__*/_react.default.createElement(_spy_routes.SpyRoute, {
  pageName: _constants.SecurityPageName.exceptions
})));
const ExceptionsListDetailRoute = () => /*#__PURE__*/_react.default.createElement(_plugin_template_wrapper.PluginTemplateWrapper, null, /*#__PURE__*/_react.default.createElement(_public.TrackApplicationView, {
  viewId: _constants.SecurityPageName.exceptions
}, /*#__PURE__*/_react.default.createElement(_pages.ListsDetailView, null)));
const ExceptionsContainerComponent = () => {
  (0, _use_readonly_header.useReadonlyHeader)(i18n.READ_ONLY_BADGE_TOOLTIP);
  return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Switch, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants.EXCEPTIONS_PATH,
    exact: true,
    component: ExceptionsRoutes
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants.EXCEPTION_LIST_DETAIL_PATH,
    component: ExceptionsListDetailRoute
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    component: _.NotFoundPage
  }));
};
const Exceptions = /*#__PURE__*/_react.default.memo(ExceptionsContainerComponent);
const renderExceptionsRoutes = () => /*#__PURE__*/_react.default.createElement(Exceptions, null);
const routes = [{
  path: _constants.EXCEPTIONS_PATH,
  render: renderExceptionsRoutes
}];
exports.routes = routes;