"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCreateSharedExceptionListWithOptionalSignal = exports.createSharedExceptionList = void 0;
var _securitysolutionHookUtils = require("@kbn/securitysolution-hook-utils");
var _constants = require("../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createSharedExceptionList = async ({
  name,
  description,
  http,
  signal
}) => {
  const res = await http.post(_constants.SHARED_EXCEPTION_LIST_URL, {
    body: JSON.stringify({
      name,
      description
    }),
    headers: {
      'Content-Type': 'application/json'
    },
    method: 'POST',
    signal
  });
  return res;
};
exports.createSharedExceptionList = createSharedExceptionList;
const createSharedExceptionListWithOptionalSignal = (0, _securitysolutionHookUtils.withOptionalSignal)(createSharedExceptionList);
const useCreateSharedExceptionListWithOptionalSignal = () => (0, _securitysolutionHookUtils.useAsync)(createSharedExceptionListWithOptionalSignal);
exports.useCreateSharedExceptionListWithOptionalSignal = useCreateSharedExceptionListWithOptionalSignal;