"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExceptionsTableUtilityBar = void 0;
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
var _utility_bar = require("../../../common/components/utility_bar");
var i18n = _interopRequireWildcard(require("../../translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ExceptionsTableUtilityBar = ({
  onRefresh,
  totalExceptionLists,
  setSort,
  sort,
  sortFields
}) => {
  var _sortFields$find;
  const selectedSortField = sortFields === null || sortFields === void 0 ? void 0 : sortFields.find(sortField => sortField.field === (sort === null || sort === void 0 ? void 0 : sort.field));
  return /*#__PURE__*/_react.default.createElement(_utility_bar.UtilityBar, {
    border: true
  }, /*#__PURE__*/_react.default.createElement(_utility_bar.UtilityBarSection, null, /*#__PURE__*/_react.default.createElement(_utility_bar.UtilityBarGroup, null, /*#__PURE__*/_react.default.createElement(_utility_bar.UtilityBarText, {
    dataTestSubj: "showingExceptionLists"
  }, i18n.SHOWING_EXCEPTION_LISTS(totalExceptionLists))), /*#__PURE__*/_react.default.createElement(_utility_bar.UtilityBarGroup, null, /*#__PURE__*/_react.default.createElement(_utility_bar.UtilityBarAction, {
    dataTestSubj: "refreshRulesAction",
    iconSide: "left",
    iconType: "refresh",
    onClick: onRefresh
  }, i18n.REFRESH_EXCEPTIONS_TABLE))), /*#__PURE__*/_react.default.createElement(_utility_bar.UtilityBarSection, null, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_utility_bar.UtilityBarGroup, null, sort && /*#__PURE__*/_react.default.createElement(_utility_bar.UtilityBarAction, {
    dataTestSubj: "sortExceptions",
    iconSide: "right",
    iconType: sort.order === 'asc' ? 'sortUp' : 'sortDown',
    popoverPanelPaddingSize: 's',
    popoverContent: () => /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
      size: "s",
      items: sortFields === null || sortFields === void 0 ? void 0 : sortFields.map(item => {
        const isSelectedSortItem = (selectedSortField === null || selectedSortField === void 0 ? void 0 : selectedSortField.field) === item.field;
        let nextSortOrder = item.defaultOrder;
        if (isSelectedSortItem) {
          nextSortOrder = sort.order === 'asc' ? 'desc' : 'asc';
        }
        return /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
          key: item.field,
          onClick: () => setSort === null || setSort === void 0 ? void 0 : setSort({
            field: item.field,
            order: nextSortOrder
          })
        }, /*#__PURE__*/_react.default.createElement(SortMenuItem, null, item.label, ' ', (selectedSortField === null || selectedSortField === void 0 ? void 0 : selectedSortField.field) === item.field && /*#__PURE__*/_react.default.createElement(SortIcon, {
          type: sort.order === 'asc' ? 'sortUp' : 'sortDown'
        })));
      })
    })
  }, /*#__PURE__*/_react.default.createElement(SortMenuItem, null, i18n.SORT_BY, ' ', sortFields === null || sortFields === void 0 ? void 0 : (_sortFields$find = sortFields.find(sortField => sortField.field === sort.field)) === null || _sortFields$find === void 0 ? void 0 : _sortFields$find.label))))));
};
exports.ExceptionsTableUtilityBar = ExceptionsTableUtilityBar;
const SortMenuItem = (0, _styledComponents.default)('div')`
  display: flex;
  align-items: center;
`;
const SortIcon = (0, _styledComponents.default)(_eui.EuiIcon)`
  margin-left: 8px;
`;
ExceptionsTableUtilityBar.displayName = 'ExceptionsTableUtilityBar';