"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ListsSearchBar = exports.EXCEPTIONS_SEARCH_SCHEMA = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("../../translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// TODO replace this component with the @Kbn/securitysolution-exception-list-components
const EXCEPTIONS_SEARCH_SCHEMA = {
  strict: true,
  fields: {
    created_by: {
      type: 'string'
    },
    name: {
      type: 'string'
    },
    type: {
      type: 'string'
    },
    list_id: {
      type: 'string'
    },
    tags: {
      type: 'string'
    }
  }
};
exports.EXCEPTIONS_SEARCH_SCHEMA = EXCEPTIONS_SEARCH_SCHEMA;
const ListsSearchBar = /*#__PURE__*/_react.default.memo(({
  onSearch
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSearchBar, {
    "data-test-subj": "exceptionsHeaderSearch",
    "aria-label": i18n.EXCEPTIONS_LISTS_SEARCH_PLACEHOLDER,
    onChange: onSearch,
    box: {
      [`data-test-subj`]: 'exceptionsHeaderSearchInput',
      placeholder: i18n.EXCEPTION_LIST_SEARCH_PLACEHOLDER,
      incremental: false,
      schema: EXCEPTIONS_SEARCH_SCHEMA
    }
  });
});
exports.ListsSearchBar = ListsSearchBar;
ListsSearchBar.displayName = 'ListsSearchBar';