"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ImportExceptionListFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _use_import_exception_list = require("../../hooks/use_import_exception_list");
var i18n = _interopRequireWildcard(require("../../translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ImportExceptionListFlyout = /*#__PURE__*/_react.default.memo(({
  handleRefresh,
  http,
  addSuccess,
  addError,
  setDisplayImportListFlyout
}) => {
  var _importExceptionListS6;
  const filePickerRef = (0, _react.useRef)(null);
  const filePickerId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'filePicker'
  });
  const [files, setFiles] = (0, _react.useState)(null);
  const [overwrite, setOverwrite] = (0, _react.useState)(false);
  const [asNewList, setAsNewList] = (0, _react.useState)(false);
  const [alreadyExistingItem, setAlreadyExistingItem] = (0, _react.useState)(false);
  const resetForm = (0, _react.useCallback)(() => {
    var _filePickerRef$curren;
    if ((_filePickerRef$curren = filePickerRef.current) !== null && _filePickerRef$curren !== void 0 && _filePickerRef$curren.fileInput) {
      filePickerRef.current.fileInput.value = '';
      filePickerRef.current.handleChange();
    }
    setFiles(null);
    setAlreadyExistingItem(false);
    setAsNewList(false);
    setOverwrite(false);
  }, []);
  const {
    start: importExceptionList,
    ...importExceptionListState
  } = (0, _use_import_exception_list.useImportExceptionList)();
  const ctrl = (0, _react.useRef)(new AbortController());
  const handleImportExceptionList = (0, _react.useCallback)(() => {
    if (!importExceptionListState.loading && files) {
      ctrl.current = new AbortController();
      Array.from(files).forEach(file => importExceptionList({
        file,
        http,
        signal: ctrl.current.signal,
        overwrite,
        overwriteExceptions: overwrite,
        asNewList
      }));
    }
  }, [asNewList, files, http, importExceptionList, importExceptionListState.loading, overwrite]);
  const handleImportSuccess = (0, _react.useCallback)(response => {
    resetForm();
    addSuccess({
      title: i18n.UPLOAD_SUCCESS_TITLE
    });
    handleRefresh();
  }, [resetForm, addSuccess, handleRefresh]);
  const handleImportErrors = (0, _react.useCallback)(errors => {
    errors.forEach(error => {
      if (!error.error.message.includes('AbortError')) {
        addError(error.error.message, {
          title: i18n.UPLOAD_ERROR
        });
      }
    });
  }, [addError]);
  (0, _react.useEffect)(() => {
    if (!importExceptionListState.loading) {
      var _importExceptionListS;
      if (importExceptionListState !== null && importExceptionListState !== void 0 && (_importExceptionListS = importExceptionListState.result) !== null && _importExceptionListS !== void 0 && _importExceptionListS.success) {
        handleImportSuccess(importExceptionListState === null || importExceptionListState === void 0 ? void 0 : importExceptionListState.result);
      } else {
        var _importExceptionListS2, _importExceptionListS4;
        const errorsToDisplay = [];
        // @ts-expect-error
        if (importExceptionListState !== null && importExceptionListState !== void 0 && (_importExceptionListS2 = importExceptionListState.error) !== null && _importExceptionListS2 !== void 0 && _importExceptionListS2.body) {
          var _importExceptionListS3;
          errorsToDisplay.push({
            // @ts-expect-error
            error: {
              ...(importExceptionListState === null || importExceptionListState === void 0 ? void 0 : (_importExceptionListS3 = importExceptionListState.error) === null || _importExceptionListS3 === void 0 ? void 0 : _importExceptionListS3.body)
            }
          });
        }
        if (importExceptionListState !== null && importExceptionListState !== void 0 && (_importExceptionListS4 = importExceptionListState.result) !== null && _importExceptionListS4 !== void 0 && _importExceptionListS4.errors) {
          var _importExceptionListS5;
          importExceptionListState === null || importExceptionListState === void 0 ? void 0 : (_importExceptionListS5 = importExceptionListState.result) === null || _importExceptionListS5 === void 0 ? void 0 : _importExceptionListS5.errors.forEach(err => {
            if (err.error.message.includes('already exists')) {
              setAlreadyExistingItem(true);
            }
            errorsToDisplay.push(err);
          });
        }
        handleImportErrors(errorsToDisplay);
      }
    }
  }, [handleImportErrors, handleImportSuccess, importExceptionListState === null || importExceptionListState === void 0 ? void 0 : importExceptionListState.error, importExceptionListState.loading, importExceptionListState === null || importExceptionListState === void 0 ? void 0 : importExceptionListState.result, importExceptionListState === null || importExceptionListState === void 0 ? void 0 : (_importExceptionListS6 = importExceptionListState.result) === null || _importExceptionListS6 === void 0 ? void 0 : _importExceptionListS6.errors]);
  const handleFileChange = (0, _react.useCallback)(inputFiles => {
    setFiles(inputFiles !== null && inputFiles !== void 0 ? inputFiles : null);
  }, []);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    ownFocus: true,
    size: "s",
    onClose: () => setDisplayImportListFlyout(false)
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", null, i18n.IMPORT_EXCEPTION_LIST_HEADER))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, i18n.IMPORT_EXCEPTION_LIST_BODY), /*#__PURE__*/_react.default.createElement(_eui.EuiFilePicker, {
    id: filePickerId,
    multiple: true,
    ref: filePickerRef,
    initialPromptText: i18n.IMPORT_PROMPT,
    onChange: handleFileChange,
    display: 'large',
    "aria-label": "Use aria labels when no actual label is in use"
  }), alreadyExistingItem && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: 'danger'
  }, i18n.IMPORT_EXCEPTION_LIST_WARNING), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    id: 'basicCheckboxId',
    label: i18n.IMPORT_EXCEPTION_LIST_OVERWRITE,
    checked: overwrite,
    onChange: e => {
      setOverwrite(!overwrite);
      setAsNewList(false);
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    id: 'createNewListCheckbox',
    label: i18n.IMPORT_EXCEPTION_LIST_AS_NEW_LIST,
    checked: asNewList,
    onChange: e => {
      setAsNewList(!asNewList);
      setOverwrite(false);
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "cross",
    onClick: () => setDisplayImportListFlyout(false),
    flush: "left"
  }, i18n.CLOSE_FLYOUT)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "exception-lists-form-import-action",
    onClick: handleImportExceptionList,
    disabled: files == null || importExceptionListState.loading
  }, i18n.UPLOAD_BUTTON)))));
});
exports.ImportExceptionListFlyout = ImportExceptionListFlyout;