"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateList = exports.unlinkListFromRules = exports.linkListToRules = exports.getListRules = exports.getListById = void 0;
var _securitysolutionListApi = require("@kbn/securitysolution-list-api");
var _securitysolutionListUtils = require("@kbn/securitysolution-list-utils");
var _std = require("@kbn/std");
var _constants = require("../../../common/endpoint/service/artifacts/constants");
var _api = require("../../detection_engine/rule_management/api/api");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getListById = async ({
  id,
  http
}) => {
  try {
    const abortCtrl = new AbortController();
    const filters = (0, _securitysolutionListUtils.getFilters)({
      filters: {
        list_id: id
      },
      namespaceTypes: ['single', 'agnostic'],
      hideLists: _constants.ALL_ENDPOINT_ARTIFACT_LIST_IDS
    });
    const namespaceTypes = ['single', 'agnostic'].join();
    const {
      data
    } = await (0, _securitysolutionListApi.fetchExceptionLists)({
      filters,
      http: http,
      signal: abortCtrl.signal,
      namespaceTypes,
      pagination: {}
    });
    abortCtrl.abort();
    if (data && data.length) return data[0];
    return null;
  } catch (error) {
    throw new Error(error);
  }
};
exports.getListById = getListById;
const getListRules = async listId => {
  try {
    const abortCtrl = new AbortController();
    const {
      data: rules
    } = await (0, _api.fetchRules)({
      signal: abortCtrl.signal,
      pagination: {
        page: 1,
        perPage: 10000
      }
    });
    abortCtrl.abort();
    return rules.reduce((acc, rule, index) => {
      var _rule$exceptions_list;
      const listExceptions = (_rule$exceptions_list = rule.exceptions_list) === null || _rule$exceptions_list === void 0 ? void 0 : _rule$exceptions_list.find(exceptionList => exceptionList.list_id === listId);
      if (listExceptions) acc.push(rule);
      return acc;
    }, []);
  } catch (error) {
    throw new Error(error);
  }
};
exports.getListRules = getListRules;
const updateList = async ({
  list,
  http
}) => {
  try {
    const abortCtrl = new AbortController();
    await (0, _securitysolutionListApi.updateExceptionList)({
      http: http,
      list,
      signal: abortCtrl.signal
    });
    abortCtrl.abort();
  } catch (error) {
    throw new Error(error);
  }
};
exports.updateList = updateList;
const unlinkListFromRules = async ({
  rules,
  listId
}) => {
  try {
    if (!rules.length) return;
    const abortCtrl = new AbortController();
    await (0, _std.asyncForEach)(rules, async rule => {
      var _rule$exceptions_list2;
      const exceptionLists = ((_rule$exceptions_list2 = rule.exceptions_list) !== null && _rule$exceptions_list2 !== void 0 ? _rule$exceptions_list2 : []).filter(({
        list_id: id
      }) => id !== listId);
      await (0, _api.patchRule)({
        ruleProperties: {
          rule_id: rule.rule_id,
          exceptions_list: exceptionLists
        },
        signal: abortCtrl.signal
      });
    });
  } catch (error) {
    throw new Error(error);
  }
};
exports.unlinkListFromRules = unlinkListFromRules;
const linkListToRules = async ({
  rules,
  listId,
  id,
  listType,
  listNamespaceType
}) => {
  try {
    if (!rules.length) return;
    const abortCtrl = new AbortController();
    await (0, _std.asyncForEach)(rules, async rule => {
      var _rule$exceptions_list3;
      const newExceptionList = {
        list_id: listId,
        id,
        type: listType,
        namespace_type: listNamespaceType
      };
      const exceptionLists = [...((_rule$exceptions_list3 = rule.exceptions_list) !== null && _rule$exceptions_list3 !== void 0 ? _rule$exceptions_list3 : []), newExceptionList];
      await (0, _api.patchRule)({
        ruleProperties: {
          rule_id: rule.rule_id,
          exceptions_list: exceptionLists
        },
        signal: abortCtrl.signal
      });
    });
  } catch (error) {
    throw new Error(error);
  }
};
exports.linkListToRules = linkListToRules;