"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.threatDefault = exports.stepDefineDefaultValue = exports.stepAboutDefaultValue = exports.ruleStepsOrder = exports.getTrailingBreadcrumbs = exports.getStepScheduleDefaultValue = exports.defaultCustomQuery = void 0;
var _utils = require("../../../../../common/detection_engine/utils");
var _translations = require("../../../../timelines/components/timeline/translations");
var _redirect_to_detection_engine = require("../../../../common/components/link_to/redirect_to_detection_engine");
var i18nRules = _interopRequireWildcard(require("./translations"));
var _types = require("../../../../app/types");
var _constants = require("../../../../../common/constants");
var _types2 = require("./types");
var _rule_schema = require("../../../../../common/detection_engine/rule_schema");
var _rule_details = require("../../../../detection_engine/rule_details_ui/pages/rule_details");
var _translations3 = require("../../../../detection_engine/rule_details_ui/pages/rule_details/translations");
var _helpers = require("./helpers");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ruleStepsOrder = [_types2.RuleStep.defineRule, _types2.RuleStep.aboutRule, _types2.RuleStep.scheduleRule, _types2.RuleStep.ruleActions];
exports.ruleStepsOrder = ruleStepsOrder;
const getRuleDetailsTabName = tabName => {
  var _RULE_DETAILS_TAB_NAM;
  return (_RULE_DETAILS_TAB_NAM = _rule_details.RULE_DETAILS_TAB_NAME[tabName]) !== null && _RULE_DETAILS_TAB_NAM !== void 0 ? _RULE_DETAILS_TAB_NAM : _rule_details.RULE_DETAILS_TAB_NAME[_rule_details.RuleDetailTabs.alerts];
};
const isRuleCreatePage = pathname => pathname.includes(_constants.RULES_PATH) && pathname.includes('/create');
const isRuleEditPage = pathname => pathname.includes(_constants.RULES_PATH) && pathname.includes('/edit');
const getTrailingBreadcrumbs = (params, getSecuritySolutionUrl) => {
  var _params$state, _params$state2, _params$state3;
  let breadcrumb = [];
  if (params.detailName && (_params$state = params.state) !== null && _params$state !== void 0 && _params$state.ruleName) {
    breadcrumb = [...breadcrumb, {
      text: params.state.ruleName,
      href: getSecuritySolutionUrl({
        deepLinkId: _types.SecurityPageName.rules,
        path: (0, _redirect_to_detection_engine.getRuleDetailsUrl)(params.detailName, '')
      })
    }];
  }
  if (params.detailName && (_params$state2 = params.state) !== null && _params$state2 !== void 0 && _params$state2.ruleName && params.tabName) {
    breadcrumb = [...breadcrumb, {
      text: getRuleDetailsTabName(params.tabName),
      href: getSecuritySolutionUrl({
        deepLinkId: _types.SecurityPageName.rules,
        path: (0, _redirect_to_detection_engine.getRuleDetailsTabUrl)(params.detailName, params.tabName, '')
      })
    }];
  }
  if (isRuleCreatePage(params.pathName)) {
    breadcrumb = [...breadcrumb, {
      text: i18nRules.ADD_PAGE_TITLE,
      href: ''
    }];
  }
  if (isRuleEditPage(params.pathName) && params.detailName && (_params$state3 = params.state) !== null && _params$state3 !== void 0 && _params$state3.ruleName) {
    breadcrumb = [...breadcrumb, {
      text: i18nRules.EDIT_PAGE_TITLE,
      href: ''
    }];
  }
  if (!isRuleEditPage(params.pathName) && params.state && !params.state.isExistingRule) {
    breadcrumb = [...breadcrumb, {
      text: _translations3.DELETED_RULE,
      href: ''
    }];
  }
  return breadcrumb;
};
exports.getTrailingBreadcrumbs = getTrailingBreadcrumbs;
const threatDefault = [{
  framework: 'MITRE ATT&CK',
  tactic: {
    id: 'none',
    name: 'none',
    reference: 'none'
  },
  technique: []
}];
exports.threatDefault = threatDefault;
const stepDefineDefaultValue = {
  anomalyThreshold: 50,
  index: [],
  indexPattern: {
    fields: [],
    title: ''
  },
  machineLearningJobId: [],
  ruleType: 'query',
  threatIndex: [],
  queryBar: {
    query: {
      query: '',
      language: 'kuery'
    },
    filters: [],
    saved_id: null
  },
  threatQueryBar: {
    query: {
      query: _constants.DEFAULT_THREAT_MATCH_QUERY,
      language: 'kuery'
    },
    filters: [],
    saved_id: null
  },
  requiredFields: [],
  relatedIntegrations: [],
  threatMapping: [],
  threshold: {
    field: [],
    value: '200',
    cardinality: {
      field: [],
      value: ''
    }
  },
  timeline: {
    id: null,
    title: _translations.DEFAULT_TIMELINE_TITLE
  },
  eqlOptions: {},
  dataSourceType: _types2.DataSourceType.IndexPatterns,
  newTermsFields: [],
  historyWindowSize: '7d',
  shouldLoadQueryDynamically: false,
  groupByFields: [],
  groupByRadioSelection: _types2.GroupByOptions.PerRuleExecution,
  groupByDuration: {
    value: 5,
    unit: 'm'
  },
  suppressionMissingFields: _rule_schema.DEFAULT_SUPPRESSION_MISSING_FIELDS_STRATEGY
};
exports.stepDefineDefaultValue = stepDefineDefaultValue;
const stepAboutDefaultValue = {
  author: [],
  name: '',
  description: '',
  isAssociatedToEndpointList: false,
  isBuildingBlock: false,
  severity: {
    value: 'low',
    mapping: (0, _helpers.fillEmptySeverityMappings)([]),
    isMappingChecked: false
  },
  riskScore: {
    value: 21,
    mapping: [],
    isMappingChecked: false
  },
  references: [''],
  falsePositives: [''],
  license: '',
  ruleNameOverride: '',
  tags: [],
  timestampOverride: '',
  threat: threatDefault,
  note: '',
  threatIndicatorPath: undefined,
  timestampOverrideFallbackDisabled: undefined
};
exports.stepAboutDefaultValue = stepAboutDefaultValue;
const DEFAULT_INTERVAL = '5m';
const DEFAULT_FROM = '1m';
const THREAT_MATCH_INTERVAL = '1h';
const THREAT_MATCH_FROM = '5m';
const getStepScheduleDefaultValue = ruleType => {
  return {
    interval: (0, _utils.isThreatMatchRule)(ruleType) ? THREAT_MATCH_INTERVAL : DEFAULT_INTERVAL,
    from: (0, _utils.isThreatMatchRule)(ruleType) ? THREAT_MATCH_FROM : DEFAULT_FROM
  };
};

/**
 * This default query will be used for threat query/indicator matches
 * as the default when the user swaps to using it by changing their
 * rule type from any rule type to the "threatMatchRule" type. Only
 * difference is that "*:*" is used instead of '' for its query.
 */
exports.getStepScheduleDefaultValue = getStepScheduleDefaultValue;
const threatQueryBarDefaultValue = {
  ...stepDefineDefaultValue.queryBar,
  query: {
    ...stepDefineDefaultValue.queryBar.query,
    query: '*:*'
  }
};
const defaultCustomQuery = {
  forNormalRules: stepDefineDefaultValue.queryBar,
  forThreatMatchRules: threatQueryBarDefaultValue
};
exports.defaultCustomQuery = defaultCustomQuery;