"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGetSavedQuery = void 0;
var _react = require("react");
var _reactQuery = require("@tanstack/react-query");
var _saved_query_services = require("../../../../common/utils/saved_query_services");
var _use_app_toasts = require("../../../../common/hooks/use_app_toasts");
var _translations = require("./translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useGetSavedQuery = (savedQueryId, {
  ruleType,
  onError
}) => {
  var _query$data;
  const savedQueryServices = (0, _saved_query_services.useSavedQueryServices)();
  const {
    addError
  } = (0, _use_app_toasts.useAppToasts)();
  const defaultErrorHandler = e => {
    addError(e, {
      title: _translations.SAVED_QUERY_LOAD_ERROR_TOAST
    });
  };
  const query = (0, _reactQuery.useQuery)(['detectionEngine', 'rule', 'savedQuery', savedQueryId], async () => {
    // load saved query only if rule type === 'saved_query', as other rule types still can have saved_id property that is not used
    // Rule schema allows to save any rule with saved_id property, but it only used for saved_query rule type
    // In future we might look in possibility to restrict rule schema (breaking change!) and remove saved_id from the rest of rules through migration
    if (!savedQueryId || ruleType !== 'saved_query') {
      return null;
    }
    return savedQueryServices.getSavedQuery(savedQueryId);
  }, {
    onError: onError !== null && onError !== void 0 ? onError : defaultErrorHandler,
    retry: false
  });
  const savedQueryBar = (0, _react.useMemo)(() => {
    var _query$data$attribute;
    return query.data ? {
      saved_id: query.data.id,
      filters: (_query$data$attribute = query.data.attributes.filters) !== null && _query$data$attribute !== void 0 ? _query$data$attribute : [],
      query: query.data.attributes.query,
      title: query.data.attributes.title
    } : null;
  }, [query.data]);
  return {
    isSavedQueryLoading: savedQueryId ? query.isLoading : false,
    savedQueryBar,
    savedQuery: (_query$data = query.data) !== null && _query$data !== void 0 ? _query$data : undefined
  };
};
exports.useGetSavedQuery = useGetSavedQuery;