"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditRuleSettingButtonLink = EditRuleSettingButtonLink;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _kibana = require("../../../../../../common/lib/kibana");
var _links = require("../../../../../../common/components/links");
var _constants = require("../../../../../../../common/constants");
var _types = require("../../../../../../app/types");
var _redirect_to_detection_engine = require("../../../../../../common/components/link_to/redirect_to_detection_engine");
var ruleI18n = _interopRequireWildcard(require("../../translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function EditRuleSettingButtonLink({
  ruleId,
  disabled = false,
  disabledReason
}) {
  const {
    application: {
      navigateToApp
    }
  } = (0, _kibana.useKibana)().services;
  const goToEditRule = (0, _react.useCallback)(ev => {
    ev.preventDefault();
    navigateToApp(_constants.APP_UI_ID, {
      deepLinkId: _types.SecurityPageName.rules,
      path: (0, _redirect_to_detection_engine.getEditRuleUrl)(ruleId)
    });
  }, [navigateToApp, ruleId]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: disabledReason
  }, /*#__PURE__*/_react.default.createElement(_links.SecuritySolutionLinkButton, {
    "data-test-subj": "editRuleSettingsLink",
    onClick: goToEditRule,
    iconType: "controlsHorizontal",
    isDisabled: disabled,
    deepLinkId: _types.SecurityPageName.rules,
    path: (0, _redirect_to_detection_engine.getEditRuleUrl)(ruleId)
  }, ruleI18n.EDIT_RULE_SETTINGS));
}