"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Alerts = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _public = require("@kbn/usage-collection-plugin/public");
var _constants = require("../../../../common/constants");
var _ = require("../../../app/404");
var i18n = _interopRequireWildcard(require("./translations"));
var _detection_engine = require("../detection_engine/detection_engine");
var _spy_routes = require("../../../common/utils/route/spy_routes");
var _use_readonly_header = require("../../../use_readonly_header");
var _alert_details_redirect = require("./alert_details_redirect");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AlertsRoute = () => /*#__PURE__*/_react.default.createElement(_public.TrackApplicationView, {
  viewId: _constants.SecurityPageName.alerts
}, /*#__PURE__*/_react.default.createElement(_detection_engine.DetectionEnginePage, null), /*#__PURE__*/_react.default.createElement(_spy_routes.SpyRoute, {
  pageName: _constants.SecurityPageName.alerts
}));
const AlertsContainerComponent = () => {
  (0, _use_readonly_header.useReadonlyHeader)(i18n.READ_ONLY_BADGE_TOOLTIP);
  return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Switch, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants.ALERTS_PATH,
    exact: true,
    component: AlertsRoute
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: `${_constants.ALERT_DETAILS_REDIRECT_PATH}/:alertId`,
    component: _alert_details_redirect.AlertDetailsRedirect
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    component: _.NotFoundPage
  }));
};
const Alerts = /*#__PURE__*/_react.default.memo(AlertsContainerComponent);
exports.Alerts = Alerts;