"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DetailsSummaryTab = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _types = require("../../../../../../common/types");
var _use_detail_panel = require("../../../../../timelines/components/side_panel/hooks/use_detail_panel");
var _kibana = require("../../../../../common/lib/kibana");
var _model = require("../../../../../common/store/sourcerer/model");
var _alert_renderer_panel = require("./alert_renderer_panel");
var _rule_panel = require("./rule_panel");
var _cases_panel = require("./cases_panel");
var _host_panel = require("./host_panel");
var _user_panel = require("./user_panel");
var _wrappers = require("./wrappers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DetailsSummaryTab = /*#__PURE__*/_react.default.memo(({
  dataAsNestedObject,
  detailsData,
  searchHit,
  eventId,
  sourcererDataView
}) => {
  const userCasesPermissions = (0, _kibana.useGetUserCasesPermissions)();
  const {
    DetailsPanel,
    openHostDetailsPanel,
    openUserDetailsPanel
  } = (0, _use_detail_panel.useDetailPanel)({
    isFlyoutView: true,
    sourcererScope: _model.SourcererScopeName.detections,
    scopeId: _types.TimelineId.detectionsAlertDetailsPage
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": "alert-details-page-summary-tab",
    direction: "row",
    wrap: true
  }, /*#__PURE__*/_react.default.createElement(_wrappers.SummaryColumn, {
    grow: 2
  }, /*#__PURE__*/_react.default.createElement(_alert_renderer_panel.AlertRendererPanel, {
    dataAsNestedObject: dataAsNestedObject
  }), /*#__PURE__*/_react.default.createElement(_rule_panel.RulePanel, {
    id: eventId,
    data: detailsData,
    searchHit: searchHit,
    browserFields: sourcererDataView.browserFields
  }), /*#__PURE__*/_react.default.createElement(_wrappers.SummaryRow, null, /*#__PURE__*/_react.default.createElement(_host_panel.HostPanel, {
    id: eventId,
    data: detailsData,
    openHostDetailsPanel: openHostDetailsPanel,
    selectedPatterns: sourcererDataView.selectedPatterns,
    browserFields: sourcererDataView.browserFields
  }), /*#__PURE__*/_react.default.createElement(_user_panel.UserPanel, {
    data: detailsData,
    selectedPatterns: sourcererDataView.selectedPatterns,
    openUserDetailsPanel: openUserDetailsPanel
  }))), /*#__PURE__*/_react.default.createElement(_wrappers.SummaryColumn, {
    grow: 1
  }, userCasesPermissions.read ? /*#__PURE__*/_react.default.createElement(_cases_panel.CasesPanel, {
    eventId: eventId,
    dataAsNestedObject: dataAsNestedObject,
    detailsData: detailsData
  }) : /*#__PURE__*/_react.default.createElement(_cases_panel.CasesPanelNoReadPermissions, null))), DetailsPanel);
});
exports.DetailsSummaryTab = DetailsSummaryTab;
DetailsSummaryTab.displayName = 'DetailsSummaryTab';