"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RelatedCasesList = void 0;
var _eui = require("@elastic/eui");
var _casesComponents = require("@kbn/cases-components");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _links = require("../../../../../../common/components/links");
var _translation = require("../translation");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DescriptionText = (0, _styledComponents.default)(_eui.EuiText)`
  text-overflow: ellipsis;
  display: -webkit-box;
  -webkit-line-clamp: 2;
  -webkit-box-orient: vertical;
  overflow: hidden;
  word-break: normal;
`;
const ChildFlexGroup = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  margin: 0;
`;
const StyledStatusText = _styledComponents.default.span`
  margin-right: ${({
  theme
}) => theme.eui.euiSizeS};
`;
const StyledIcon = (0, _styledComponents.default)(_eui.EuiIcon)`
  margin-right: ${({
  theme
}) => theme.eui.euiSizeS};
`;
const RelatedCasesList = ({
  relatedCases,
  maximumVisible
}) => {
  // Sort related cases, showing the most recently created first.
  const sortedRelatedCases = (0, _react.useMemo)(() => relatedCases ? relatedCases.sort((case1, case2) => new Date(case2.createdAt).getTime() - new Date(case1.createdAt).getTime()) : [], [relatedCases]);

  // If a maximum visible count is provided, only show cases up to that amount
  const visibleCases = (0, _react.useMemo)(() => maximumVisible && maximumVisible > 0 ? sortedRelatedCases.slice(0, maximumVisible) : sortedRelatedCases, [maximumVisible, sortedRelatedCases]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, visibleCases === null || visibleCases === void 0 ? void 0 : visibleCases.map(({
    id,
    title,
    description,
    status,
    totals
  }) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: id
  }, /*#__PURE__*/_react.default.createElement(_links.CaseDetailsLink, {
    detailName: id,
    title: title
  }, title), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(DescriptionText, {
    color: "subdued",
    size: "relative"
  }, description), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(ChildFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    dir: "row",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(StyledStatusText, null, `${_translation.CASES_PANEL_CASE_STATUS}:`), /*#__PURE__*/_react.default.createElement(_casesComponents.Status, {
    status: status
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    dir: "row",
    alignItems: "center",
    gutterSize: "xl"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    dir: "row"
  }, /*#__PURE__*/_react.default.createElement(StyledIcon, {
    type: "editorComment"
  }), /*#__PURE__*/_react.default.createElement("span", null, totals.userComments))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    dir: "row"
  }, /*#__PURE__*/_react.default.createElement(StyledIcon, {
    type: "warning"
  }), /*#__PURE__*/_react.default.createElement("span", null, totals.alerts)))))))));
};
exports.RelatedCasesList = RelatedCasesList;