"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CasesPanelNoReadPermissions = exports.CasesPanel = exports.CASES_PANEL_CASES_COUNT_MAX = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _common = require("@kbn/cases-plugin/common");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _kibana = require("../../../../../../common/lib/kibana");
var _use_get_related_cases_by_event = require("../../../../../../common/containers/cases/use_get_related_cases_by_event");
var _translation = require("../translation");
var _wrappers = require("../wrappers");
var _cases_panel_actions = require("./cases_panel_actions");
var _related_case = require("./related_case");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StyledCasesFlexGroup = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  max-height: 300px;
  overflow-y: auto;
`;

/**
 * There is currently no api limit for the number of cases that can be returned
 * To prevent the UI from growing too large, we limit to 25 most recent cases
 */
const CASES_PANEL_CASES_COUNT_MAX = 25;
exports.CASES_PANEL_CASES_COUNT_MAX = CASES_PANEL_CASES_COUNT_MAX;
const CasesPanelLoading = () => /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
  icon: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "l"
  }),
  title: /*#__PURE__*/_react.default.createElement("h2", null, _translation.LOADING_CASES),
  titleSize: "xxs"
});
const CasesPanelError = () => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _translation.ERROR_LOADING_CASES);
const CasesPanelNoReadPermissions = () => /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
  body: _translation.CASE_NO_READ_PERMISSIONS
});
exports.CasesPanelNoReadPermissions = CasesPanelNoReadPermissions;
const CasesPanel = /*#__PURE__*/_react.default.memo(({
  eventId,
  dataAsNestedObject,
  detailsData
}) => {
  const {
    cases: casesUi
  } = (0, _kibana.useKibana)().services;
  const {
    loading,
    error,
    relatedCases,
    refetchRelatedCases
  } = (0, _use_get_related_cases_by_event.useGetRelatedCasesByEvent)(eventId);
  const userCasesPermissions = (0, _kibana.useGetUserCasesPermissions)();
  const caseAttachments = (0, _react.useMemo)(() => {
    var _dataAsNestedObject$_;
    return dataAsNestedObject ? [{
      alertId: eventId,
      index: (_dataAsNestedObject$_ = dataAsNestedObject._index) !== null && _dataAsNestedObject$_ !== void 0 ? _dataAsNestedObject$_ : '',
      type: _common.CommentType.alert,
      rule: casesUi.helpers.getRuleIdFromEvent({
        ecs: dataAsNestedObject,
        data: detailsData
      })
    }] : [];
  }, [casesUi.helpers, dataAsNestedObject, detailsData, eventId]);
  const createCaseFlyout = casesUi.hooks.useCasesAddToNewCaseFlyout({
    onSuccess: refetchRelatedCases
  });
  const selectCaseModal = casesUi.hooks.useCasesAddToExistingCaseModal({
    onSuccess: refetchRelatedCases
  });
  const addToNewCase = (0, _react.useCallback)(() => {
    if (userCasesPermissions.create) {
      createCaseFlyout.open({
        attachments: caseAttachments
      });
    }
  }, [userCasesPermissions.create, createCaseFlyout, caseAttachments]);
  const addToExistingCase = (0, _react.useCallback)(() => {
    if (userCasesPermissions.update) {
      selectCaseModal.open({
        getAttachments: () => caseAttachments
      });
    }
  }, [caseAttachments, selectCaseModal, userCasesPermissions.update]);
  const renderCasesActions = (0, _react.useCallback)(() => /*#__PURE__*/_react.default.createElement(_cases_panel_actions.CasesPanelActions, {
    addToNewCase: addToNewCase,
    addToExistingCase: addToExistingCase,
    eventId: eventId,
    dataAsNestedObject: dataAsNestedObject,
    detailsData: detailsData,
    userCasesPermissions: userCasesPermissions
  }), [addToExistingCase, addToNewCase, dataAsNestedObject, detailsData, eventId, userCasesPermissions]);

  // Sort by most recently created being first
  const relatedCasesCount = relatedCases ? relatedCases.length : 0;
  const visibleCaseCount = (0, _react.useMemo)(() => Math.min(relatedCasesCount, CASES_PANEL_CASES_COUNT_MAX), [relatedCasesCount]);
  const hasRelatedCases = relatedCasesCount > 0;
  if (loading) return /*#__PURE__*/_react.default.createElement(CasesPanelLoading, null);
  if (error || relatedCases === undefined) return /*#__PURE__*/_react.default.createElement(CasesPanelError, null);
  return /*#__PURE__*/_react.default.createElement(_wrappers.SummaryPanel, {
    actionsClassName: _cases_panel_actions.CASES_PANEL_ACTIONS_CLASS,
    title: _translation.CASES_PANEL_TITLE,
    description: hasRelatedCases ? (0, _translation.CASES_PANEL_SUBTITLE)(visibleCaseCount) : undefined,
    renderActionsPopover: hasRelatedCases ? renderCasesActions : undefined
  }, hasRelatedCases ? /*#__PURE__*/_react.default.createElement(StyledCasesFlexGroup, {
    direction: "column",
    "data-test-subj": "case-panel"
  }, /*#__PURE__*/_react.default.createElement(_related_case.RelatedCasesList, {
    maximumVisible: CASES_PANEL_CASES_COUNT_MAX,
    relatedCases: relatedCases
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    iconColor: "default",
    body: _translation.NO_RELATED_CASES_FOUND,
    actions: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, userCasesPermissions.update && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      size: "s",
      "data-test-subj": "add-to-existing-case-button",
      color: "primary",
      onClick: addToExistingCase
    }, _translation.ADD_TO_EXISTING_CASE_BUTTON)), userCasesPermissions.create && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      size: "s",
      "data-test-subj": "add-to-new-case-button",
      color: "primary",
      fill: true,
      onClick: addToNewCase
    }, _translation.ADD_TO_NEW_CASE_BUTTON)))
  }));
});
exports.CasesPanel = CasesPanel;
CasesPanel.displayName = 'CasesPanel';