"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CasesPanelActions = exports.CASES_PANEL_ACTIONS_CLASS = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _translation = require("../translation");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CASES_PANEL_ACTIONS_CLASS = 'cases-panel-actions-trigger';
exports.CASES_PANEL_ACTIONS_CLASS = CASES_PANEL_ACTIONS_CLASS;
const CasesPanelActions = /*#__PURE__*/_react.default.memo(({
  addToNewCase,
  addToExistingCase,
  className,
  userCasesPermissions
}) => {
  const [isPopoverOpen, setPopover] = (0, _react.useState)(false);
  const onButtonClick = (0, _react.useCallback)(() => {
    setPopover(!isPopoverOpen);
  }, [isPopoverOpen]);
  const closePopover = () => {
    setPopover(false);
  };
  const items = (0, _react.useMemo)(() => {
    const options = [];
    if (userCasesPermissions.create) {
      options.push( /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
        key: "casesActionsAddToNewCase",
        onClick: addToNewCase,
        "data-test-subj": "cases-panel-actions-add-to-new-case"
      }, _translation.ADD_TO_NEW_CASE_BUTTON));
    }
    if (userCasesPermissions.update) {
      options.push( /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
        key: "caseActionsAddToExistingCase",
        "data-test-subj": "cases-panel-actions-add-to-existing-case",
        onClick: addToExistingCase,
        target: "_blank"
      }, _translation.ADD_TO_EXISTING_CASE_BUTTON));
    }
    return options;
  }, [addToExistingCase, addToNewCase, userCasesPermissions.create, userCasesPermissions.update]);
  const button = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": _translation.SUMMARY_PANEL_ACTIONS,
    className: CASES_PANEL_ACTIONS_CLASS,
    iconType: "boxesHorizontal",
    onClick: onButtonClick
  }), [onButtonClick]);
  return /*#__PURE__*/_react.default.createElement("div", {
    className: className
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: button,
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    panelPaddingSize: "none",
    anchorPosition: "downLeft",
    panelClassName: "withHoverActions__popover"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    "data-test-subj": "cases-actions-panel",
    size: "s",
    items: items
  })));
});
exports.CasesPanelActions = CasesPanelActions;
CasesPanelActions.displayName = 'CasesPanelActions';