"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertRendererPanel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _renderers = require("../../../../../../timelines/components/timeline/body/renderers");
var _get_row_renderer = require("../../../../../../timelines/components/timeline/body/renderers/get_row_renderer");
var _types = require("../../../../../../../common/types");
var _wrappers = require("../wrappers");
var _translation = require("../translation");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RendererContainer = _styledComponents.default.div`
  overflow-x: auto;
  margin-left: -24px;

  & .euiFlexGroup {
    justify-content: flex-start;
  }
`;
const AlertRendererPanel = /*#__PURE__*/_react.default.memo(({
  dataAsNestedObject
}) => {
  const renderer = (0, _react.useMemo)(() => dataAsNestedObject != null ? (0, _get_row_renderer.getRowRenderer)({
    data: dataAsNestedObject,
    rowRenderers: _renderers.defaultRowRenderers
  }) : null, [dataAsNestedObject]);
  return /*#__PURE__*/_react.default.createElement(_wrappers.SummaryPanel, {
    title: _translation.ALERT_REASON_PANEL_TITLE
  }, renderer != null && dataAsNestedObject != null && /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(RendererContainer, {
    "data-test-subj": "alert-renderer-panel"
  }, renderer.renderRow({
    data: dataAsNestedObject,
    isDraggable: false,
    scopeId: _types.TimelineId.detectionsAlertDetailsPage
  }))));
});
exports.AlertRendererPanel = AlertRendererPanel;
AlertRendererPanel.displayName = 'AlertRendererPanel';