"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertDetailsPage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _eui = require("@elastic/eui");
var _reactRedux = require("react-redux");
var _timeline = require("../../../timelines/store/timeline");
var _types = require("../../../../common/types");
var _use_get_fields_data = require("../../../common/hooks/use_get_fields_data");
var _sourcerer = require("../../../common/containers/sourcerer");
var _model = require("../../../common/store/sourcerer/model");
var _spy_routes = require("../../../common/utils/route/spy_routes");
var _link_to = require("../../../common/components/link_to");
var _types2 = require("./types");
var _tab_navigation_with_breadcrumbs = require("../../../common/components/navigation/tab_navigation_with_breadcrumbs");
var _navigation = require("./utils/navigation");
var _constants = require("../../../../common/constants");
var _event = require("../../../../common/endpoint/models/event");
var _details = require("../../../timelines/containers/details");
var _loading_page = require("./components/loading_page");
var _error_page = require("./components/error_page");
var _header = require("./components/header");
var _summary = require("./tabs/summary");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AlertDetailsPage = /*#__PURE__*/(0, _react.memo)(() => {
  const {
    detailName: eventId
  } = (0, _reactRouterDom.useParams)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const sourcererDataView = (0, _sourcerer.useSourcererDataView)(_model.SourcererScopeName.detections);
  const indexName = (0, _react.useMemo)(() => sourcererDataView.selectedPatterns.join(','), [sourcererDataView.selectedPatterns]);
  const [loading, detailsData, searchHit, dataAsNestedObject] = (0, _details.useTimelineEventsDetails)({
    indexName,
    eventId,
    runtimeMappings: sourcererDataView.runtimeMappings,
    skip: !_event.eventID
  });
  const dataNotFound = !loading && !detailsData;
  const hasData = !loading && detailsData;

  // Example of using useGetFieldsData. Only place it is used currently
  const getFieldsData = (0, _use_get_fields_data.useGetFieldsData)(searchHit === null || searchHit === void 0 ? void 0 : searchHit.fields);
  const timestamp = getFieldsData(_ruleDataUtils.TIMESTAMP);
  const ruleName = getFieldsData(_ruleDataUtils.ALERT_RULE_NAME);
  (0, _react.useEffect)(() => {
    // TODO: move detail panel to it's own redux state
    dispatch(_timeline.timelineActions.createTimeline({
      id: _types.TimelineId.detectionsAlertDetailsPage,
      columns: [],
      dataViewId: null,
      indexNames: [],
      expandedDetail: {},
      show: false
    }));
  }, [dispatch]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, loading && /*#__PURE__*/_react.default.createElement(_loading_page.AlertDetailsLoadingPage, {
    eventId: eventId
  }), dataNotFound && /*#__PURE__*/_react.default.createElement(_error_page.AlertDetailsErrorPage, {
    eventId: eventId
  }), hasData && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_header.AlertDetailsHeader, {
    loading: loading,
    ruleName: ruleName,
    timestamp: timestamp
  }), /*#__PURE__*/_react.default.createElement(_tab_navigation_with_breadcrumbs.TabNavigationWithBreadcrumbs, {
    navTabs: (0, _navigation.getAlertDetailsNavTabs)(eventId)
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_reactRouterDom.Switch, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: (0, _link_to.getAlertDetailsTabUrl)(eventId, _types2.AlertDetailRouteType.summary)
  }, /*#__PURE__*/_react.default.createElement(_summary.DetailsSummaryTab, {
    eventId: eventId,
    dataAsNestedObject: dataAsNestedObject,
    searchHit: searchHit,
    detailsData: detailsData,
    sourcererDataView: sourcererDataView
  })))), /*#__PURE__*/_react.default.createElement(_spy_routes.SpyRoute, {
    pageName: _constants.SecurityPageName.alerts,
    state: {
      ruleName
    }
  }));
});
exports.AlertDetailsPage = AlertDetailsPage;