"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMitreComponentParts = void 0;
var _helpers = require("../components/rules/description_step/helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getMitreComponentParts = searchHit => {
  var _ruleParameters$;
  const ruleParameters = searchHit !== null && searchHit !== void 0 && searchHit.fields ? searchHit === null || searchHit === void 0 ? void 0 : searchHit.fields['kibana.alert.rule.parameters'] : null;
  const threat = ruleParameters ? (_ruleParameters$ = ruleParameters[0]) === null || _ruleParameters$ === void 0 ? void 0 : _ruleParameters$.threat : null;
  return threat && threat.length > 0 ? (0, _helpers.buildThreatDescription)({
    label: threat[0].framework,
    threat
  }) : null;
};
exports.getMitreComponentParts = getMitreComponentParts;