"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getUseTriggersActionsFieldBrowserOptions = void 0;
var _fields_browser = require("../../../timelines/components/fields_browser");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getUseTriggersActionsFieldBrowserOptions = scopeId => {
  const useTriggersActionsFieldBrowserOptions = ({
    onToggleColumn
  }) => {
    const options = (0, _fields_browser.useFieldBrowserOptions)({
      sourcererScope: scopeId,
      removeColumn: onToggleColumn,
      upsertColumn: column => {
        onToggleColumn(column.id);
      }
    });
    return {
      createFieldButton: options.createFieldButton
    };
  };
  return useTriggersActionsFieldBrowserOptions;
};
exports.getUseTriggersActionsFieldBrowserOptions = getUseTriggersActionsFieldBrowserOptions;