"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getPersistentControlsHook = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _use_data_table_filters = require("../../../common/hooks/use_data_table_filters");
var _use_selector = require("../../../common/hooks/use_selector");
var _right_top_menu = require("../../../common/components/events_viewer/right_top_menu");
var _additional_filters_action = require("../../components/alerts_table/additional_filters_action");
var _grouping = require("../../../common/store/grouping");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const {
  changeViewMode
} = _securitysolutionDataTable.dataTableActions;
const getPersistentControlsHook = tableId => {
  const usePersistentControls = () => {
    const dispatch = (0, _reactRedux.useDispatch)();
    const getGroupSelector = _grouping.groupSelectors.getGroupSelector();
    const groupSelector = (0, _reactRedux.useSelector)(state => getGroupSelector(state));
    const getTable = (0, _react.useMemo)(() => _securitysolutionDataTable.dataTableSelectors.getTableByIdSelector(), []);
    const tableView = (0, _use_selector.useShallowEqualSelector)(state => {
      var _viewMode, _getTable;
      return (_viewMode = ((_getTable = getTable(state, tableId)) !== null && _getTable !== void 0 ? _getTable : _securitysolutionDataTable.tableDefaults).viewMode) !== null && _viewMode !== void 0 ? _viewMode : _securitysolutionDataTable.tableDefaults.viewMode;
    });
    const handleChangeTableView = (0, _react.useCallback)(selectedView => {
      dispatch(changeViewMode({
        id: tableId,
        viewMode: selectedView
      }));
    }, [dispatch]);
    const {
      showBuildingBlockAlerts,
      setShowBuildingBlockAlerts,
      showOnlyThreatIndicatorAlerts,
      setShowOnlyThreatIndicatorAlerts
    } = (0, _use_data_table_filters.useDataTableFilters)(tableId);
    const additionalFiltersComponent = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_additional_filters_action.AdditionalFiltersAction, {
      areEventsLoading: false,
      onShowBuildingBlockAlertsChanged: setShowBuildingBlockAlerts,
      showBuildingBlockAlerts: showBuildingBlockAlerts,
      onShowOnlyThreatIndicatorAlertsChanged: setShowOnlyThreatIndicatorAlerts,
      showOnlyThreatIndicatorAlerts: showOnlyThreatIndicatorAlerts
    }), [showBuildingBlockAlerts, setShowBuildingBlockAlerts, showOnlyThreatIndicatorAlerts, setShowOnlyThreatIndicatorAlerts]);
    const rightTopMenu = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_right_top_menu.RightTopMenu, {
      position: "relative",
      tableView: tableView,
      loading: false,
      tableId: tableId,
      title: 'Some Title',
      onViewChange: handleChangeTableView,
      hasRightOffset: false,
      additionalFilters: additionalFiltersComponent,
      showInspect: false,
      additionalMenuOptions: groupSelector != null ? [groupSelector] : []
    }), [tableView, handleChangeTableView, additionalFiltersComponent, groupSelector]);
    return {
      right: rightTopMenu
    };
  };
  return usePersistentControls;
};
exports.getPersistentControlsHook = getPersistentControlsHook;