"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useListsConfig = void 0;
var _react = require("react");
var _kibana = require("../../../../common/lib/kibana");
var _use_lists_index = require("./use_lists_index");
var _use_lists_privileges = require("./use_lists_privileges");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useListsConfig = () => {
  const {
    createIndex,
    indexExists,
    loading: indexLoading,
    error: indexError
  } = (0, _use_lists_index.useListsIndex)();
  const {
    canManageIndex,
    canWriteIndex,
    loading: privilegesLoading
  } = (0, _use_lists_privileges.useListsPrivileges)();
  const {
    lists
  } = (0, _kibana.useKibana)().services;
  const enabled = lists != null;
  const loading = indexLoading || privilegesLoading;
  const needsIndex = indexExists === false;
  const hasIndexError = indexError != null;
  const needsIndexConfiguration = needsIndex && (canManageIndex === false || canManageIndex === true && hasIndexError);
  const needsConfiguration = !enabled || needsIndexConfiguration;
  (0, _react.useEffect)(() => {
    if (needsIndex && canManageIndex) {
      createIndex();
    }
  }, [canManageIndex, createIndex, needsIndex]);
  return {
    canManageIndex,
    canWriteIndex,
    enabled,
    loading,
    needsConfiguration
  };
};
exports.useListsConfig = useListsConfig;