"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCheckSignalIndex = void 0;
var _react = require("react");
var _securitysolutionTGrid = require("@kbn/securitysolution-t-grid");
var _use_app_toasts = require("../../../../common/hooks/use_app_toasts");
var _api = require("./api");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_alerts_privileges = require("./use_alerts_privileges");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Hook for managing signal index
 *
 *
 */
const useCheckSignalIndex = () => {
  const [loading, setLoading] = (0, _react.useState)(true);
  const [signalIndex, setSignalIndex] = (0, _react.useState)({
    signalIndexExists: null,
    signalIndexName: null,
    signalIndexMappingOutdated: null
  });
  const {
    addError
  } = (0, _use_app_toasts.useAppToasts)();
  const {
    hasIndexRead
  } = (0, _use_alerts_privileges.useAlertsPrivileges)();
  (0, _react.useEffect)(() => {
    let isSubscribed = true;
    const abortCtrl = new AbortController();
    const fetchData = async () => {
      try {
        setLoading(true);
        const signal = await (0, _api.checkSignalIndex)({
          signal: abortCtrl.signal
        });
        if (isSubscribed && signal != null) {
          setSignalIndex({
            signalIndexExists: signal === null || signal === void 0 ? void 0 : signal.indexExists,
            signalIndexName: signal.name,
            signalIndexMappingOutdated: signal.index_mapping_outdated
          });
        }
      } catch (error) {
        if (isSubscribed) {
          setSignalIndex({
            signalIndexExists: false,
            signalIndexName: null,
            signalIndexMappingOutdated: null
          });
          if ((0, _securitysolutionTGrid.isSecurityAppError)(error) && error.body.status_code !== 404) {
            addError(error, {
              title: i18n.SIGNAL_GET_NAME_FAILURE
            });
          }
        }
      }
      if (isSubscribed) {
        setLoading(false);
      }
    };
    if (hasIndexRead) {
      fetchData();
    } else {
      // Skip data fetching as the current user doesn't have enough priviliges.
      // Attempt to get the signal index will result in 500 error.
      setLoading(false);
    }
    return () => {
      isSubscribed = false;
      abortCtrl.abort();
    };
  }, [addError, hasIndexRead]);
  return {
    loading,
    ...signalIndex
  };
};
exports.useCheckSignalIndex = useCheckSignalIndex;