"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetchListPrivileges = void 0;
var _react = require("react");
var _securitysolutionListHooks = require("@kbn/securitysolution-list-hooks");
var _use_app_toasts = require("../../../common/hooks/use_app_toasts");
var _kibana = require("../../../common/lib/kibana");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useFetchListPrivileges = (isAppAvailable = true) => {
  const http = (0, _kibana.useHttp)();
  const {
    lists
  } = (0, _kibana.useKibana)().services;
  const {
    start: fetchListPrivileges,
    ...listPrivileges
  } = (0, _securitysolutionListHooks.useReadListPrivileges)();
  const {
    addError
  } = (0, _use_app_toasts.useAppToasts)();
  const abortCtrlRef = (0, _react.useRef)(new AbortController());
  (0, _react.useEffect)(() => {
    const {
      loading,
      result,
      error
    } = listPrivileges;
    if (isAppAvailable && lists && !loading && !(result || error)) {
      abortCtrlRef.current.abort();
      abortCtrlRef.current = new AbortController();
      fetchListPrivileges({
        http,
        signal: abortCtrlRef.current.signal
      });
    }
  }, [http, lists, fetchListPrivileges, listPrivileges, isAppAvailable]);
  (0, _react.useEffect)(() => {
    return () => {
      abortCtrlRef.current.abort();
    };
  }, []);
  (0, _react.useEffect)(() => {
    const error = listPrivileges.error;
    if (error != null) {
      addError(error, {
        title: i18n.LISTS_PRIVILEGES_FETCH_FAILURE
      });
    }
  }, [addError, listPrivileges.error]);
  return {
    loading: listPrivileges.loading,
    error: listPrivileges.error,
    result: listPrivileges.result
  };
};
exports.useFetchListPrivileges = useFetchListPrivileges;