"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.userInfoReducer = exports.useUserInfo = exports.useUserData = exports.initialState = exports.ManageUserInfo = void 0;
var _fp = require("lodash/fp");
var _react = _interopRequireWildcard(require("react"));
var _use_alerts_privileges = require("../../containers/detection_engine/alerts/use_alerts_privileges");
var _use_signal_index = require("../../containers/detection_engine/alerts/use_signal_index");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initialState = {
  canUserCRUD: null,
  canUserREAD: null,
  hasIndexManage: null,
  hasIndexMaintenance: null,
  hasIndexWrite: null,
  hasIndexRead: null,
  hasIndexUpdateDelete: null,
  isSignalIndexExists: null,
  isAuthenticated: null,
  hasEncryptionKey: null,
  loading: true,
  signalIndexName: null,
  signalIndexMappingOutdated: null
};
exports.initialState = initialState;
const userInfoReducer = (state, action) => {
  switch (action.type) {
    case 'updateLoading':
      {
        return {
          ...state,
          loading: action.loading
        };
      }
    case 'updateHasIndexManage':
      {
        return {
          ...state,
          hasIndexManage: action.hasIndexManage
        };
      }
    case 'updateHasIndexMaintenance':
      {
        return {
          ...state,
          hasIndexMaintenance: action.hasIndexMaintenance
        };
      }
    case 'updateHasIndexWrite':
      {
        return {
          ...state,
          hasIndexWrite: action.hasIndexWrite
        };
      }
    case 'updateHasIndexRead':
      {
        return {
          ...state,
          hasIndexRead: action.hasIndexRead
        };
      }
    case 'updateHasIndexUpdateDelete':
      {
        return {
          ...state,
          hasIndexUpdateDelete: action.hasIndexUpdateDelete
        };
      }
    case 'updateIsSignalIndexExists':
      {
        return {
          ...state,
          isSignalIndexExists: action.isSignalIndexExists
        };
      }
    case 'updateIsAuthenticated':
      {
        return {
          ...state,
          isAuthenticated: action.isAuthenticated
        };
      }
    case 'updateHasEncryptionKey':
      {
        return {
          ...state,
          hasEncryptionKey: action.hasEncryptionKey
        };
      }
    case 'updateSignalIndexName':
      {
        return {
          ...state,
          signalIndexName: action.signalIndexName
        };
      }
    case 'updateSignalIndexMappingOutdated':
      {
        return {
          ...state,
          signalIndexMappingOutdated: action.signalIndexMappingOutdated
        };
      }
    case 'updateCanUserCRUD':
      {
        return {
          ...state,
          canUserCRUD: action.canUserCRUD
        };
      }
    case 'updateCanUserREAD':
      {
        return {
          ...state,
          canUserREAD: action.canUserREAD
        };
      }
    default:
      return state;
  }
};
exports.userInfoReducer = userInfoReducer;
const StateUserInfoContext = /*#__PURE__*/(0, _react.createContext)([initialState, () => _fp.noop]);
const useUserData = () => (0, _react.useContext)(StateUserInfoContext);
exports.useUserData = useUserData;
const ManageUserInfo = ({
  children
}) => /*#__PURE__*/_react.default.createElement(StateUserInfoContext.Provider, {
  value: (0, _react.useReducer)(userInfoReducer, initialState)
}, children);
exports.ManageUserInfo = ManageUserInfo;
const useUserInfo = () => {
  const [{
    canUserCRUD,
    canUserREAD,
    hasIndexManage,
    hasIndexMaintenance,
    hasIndexWrite,
    hasIndexRead,
    hasIndexUpdateDelete,
    isSignalIndexExists,
    isAuthenticated,
    hasEncryptionKey,
    loading,
    signalIndexName,
    signalIndexMappingOutdated
  }, dispatch] = useUserData();
  const {
    loading: privilegeLoading,
    isAuthenticated: isApiAuthenticated,
    hasEncryptionKey: isApiEncryptionKey,
    hasIndexManage: hasApiIndexManage,
    hasIndexMaintenance: hasApiIndexMaintenance,
    hasIndexUpdateDelete: hasApiIndexUpdateDelete,
    hasIndexWrite: hasApiIndexWrite,
    hasIndexRead: hasApiIndexRead,
    hasKibanaCRUD,
    hasKibanaREAD
  } = (0, _use_alerts_privileges.useAlertsPrivileges)();
  const {
    loading: indexNameLoading,
    signalIndexExists: isApiSignalIndexExists,
    signalIndexName: apiSignalIndexName,
    signalIndexMappingOutdated: apiSignalIndexMappingOutdated,
    createDeSignalIndex: createSignalIndex
  } = (0, _use_signal_index.useSignalIndex)();
  (0, _react.useEffect)(() => {
    if (!loading && canUserCRUD !== hasKibanaCRUD) {
      dispatch({
        type: 'updateCanUserCRUD',
        canUserCRUD: hasKibanaCRUD
      });
    }
  }, [dispatch, loading, canUserCRUD, hasKibanaCRUD]);
  (0, _react.useEffect)(() => {
    if (!loading && canUserREAD !== hasKibanaREAD) {
      dispatch({
        type: 'updateCanUserREAD',
        canUserREAD: hasKibanaREAD
      });
    }
  }, [dispatch, loading, canUserREAD, hasKibanaREAD]);
  (0, _react.useEffect)(() => {
    if (loading !== (privilegeLoading || indexNameLoading)) {
      dispatch({
        type: 'updateLoading',
        loading: privilegeLoading || indexNameLoading
      });
    }
  }, [dispatch, loading, privilegeLoading, indexNameLoading]);
  (0, _react.useEffect)(() => {
    if (!loading && hasIndexManage !== hasApiIndexManage && hasApiIndexManage != null) {
      dispatch({
        type: 'updateHasIndexManage',
        hasIndexManage: hasApiIndexManage
      });
    }
  }, [dispatch, loading, hasIndexManage, hasApiIndexManage]);
  (0, _react.useEffect)(() => {
    if (!loading && hasIndexWrite !== hasApiIndexWrite && hasApiIndexWrite != null) {
      dispatch({
        type: 'updateHasIndexWrite',
        hasIndexWrite: hasApiIndexWrite
      });
    }
  }, [dispatch, loading, hasIndexWrite, hasApiIndexWrite]);
  (0, _react.useEffect)(() => {
    if (!loading && hasIndexRead !== hasApiIndexRead && hasApiIndexRead != null) {
      dispatch({
        type: 'updateHasIndexRead',
        hasIndexRead: hasApiIndexRead
      });
    }
  }, [dispatch, loading, hasIndexRead, hasApiIndexRead]);
  (0, _react.useEffect)(() => {
    if (!loading && hasIndexUpdateDelete !== hasApiIndexUpdateDelete && hasApiIndexUpdateDelete != null) {
      dispatch({
        type: 'updateHasIndexUpdateDelete',
        hasIndexUpdateDelete: hasApiIndexUpdateDelete
      });
    }
  }, [dispatch, loading, hasIndexUpdateDelete, hasApiIndexUpdateDelete]);
  (0, _react.useEffect)(() => {
    if (!loading && hasIndexMaintenance !== hasApiIndexMaintenance && hasApiIndexMaintenance != null) {
      dispatch({
        type: 'updateHasIndexMaintenance',
        hasIndexMaintenance: hasApiIndexMaintenance
      });
    }
  }, [dispatch, loading, hasIndexMaintenance, hasApiIndexMaintenance]);
  (0, _react.useEffect)(() => {
    if (!loading && isSignalIndexExists !== isApiSignalIndexExists && isApiSignalIndexExists != null) {
      dispatch({
        type: 'updateIsSignalIndexExists',
        isSignalIndexExists: isApiSignalIndexExists
      });
    }
  }, [dispatch, loading, isSignalIndexExists, isApiSignalIndexExists]);
  (0, _react.useEffect)(() => {
    if (!loading && isAuthenticated !== isApiAuthenticated && isApiAuthenticated != null) {
      dispatch({
        type: 'updateIsAuthenticated',
        isAuthenticated: isApiAuthenticated
      });
    }
  }, [dispatch, loading, isAuthenticated, isApiAuthenticated]);
  (0, _react.useEffect)(() => {
    if (!loading && hasEncryptionKey !== isApiEncryptionKey && isApiEncryptionKey != null) {
      dispatch({
        type: 'updateHasEncryptionKey',
        hasEncryptionKey: isApiEncryptionKey
      });
    }
  }, [dispatch, loading, hasEncryptionKey, isApiEncryptionKey]);
  (0, _react.useEffect)(() => {
    if (!loading && signalIndexName !== apiSignalIndexName && apiSignalIndexName != null) {
      dispatch({
        type: 'updateSignalIndexName',
        signalIndexName: apiSignalIndexName
      });
    }
  }, [dispatch, loading, signalIndexName, apiSignalIndexName]);
  (0, _react.useEffect)(() => {
    if (!loading && signalIndexMappingOutdated !== apiSignalIndexMappingOutdated && apiSignalIndexMappingOutdated != null) {
      dispatch({
        type: 'updateSignalIndexMappingOutdated',
        signalIndexMappingOutdated: apiSignalIndexMappingOutdated
      });
    }
  }, [dispatch, loading, signalIndexMappingOutdated, apiSignalIndexMappingOutdated]);
  (0, _react.useEffect)(() => {
    if (isAuthenticated && hasEncryptionKey && hasIndexManage && (isSignalIndexExists != null && !isSignalIndexExists || signalIndexMappingOutdated != null && signalIndexMappingOutdated) && createSignalIndex != null) {
      createSignalIndex();
    }
  }, [createSignalIndex, isAuthenticated, hasEncryptionKey, isSignalIndexExists, hasIndexManage, signalIndexMappingOutdated]);
  return {
    loading,
    isSignalIndexExists,
    isAuthenticated,
    hasEncryptionKey,
    canUserCRUD,
    canUserREAD,
    hasIndexManage,
    hasIndexMaintenance,
    hasIndexWrite,
    hasIndexRead,
    hasIndexUpdateDelete,
    signalIndexName,
    signalIndexMappingOutdated
  };
};
exports.useUserInfo = useUserInfo;