"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StepScheduleRule = void 0;
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _react = _interopRequireWildcard(require("react"));
var _types = require("../../../pages/detection_engine/rules/types");
var _description_step = require("../description_step");
var _schedule_item_form = require("../schedule_item_form");
var _shared_imports = require("../../../../shared_imports");
var _step_content_wrapper = require("../step_content_wrapper");
var _next_step = require("../next_step");
var _schema = require("./schema");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StyledForm = (0, _styledComponents.default)(_shared_imports.Form)`
  max-width: 235px !important;
`;
const StepScheduleRuleComponent = ({
  addPadding = false,
  defaultValues: initialState,
  descriptionColumns = 'singleSplit',
  isReadOnlyView,
  isLoading,
  isUpdateView = false,
  onSubmit,
  setForm,
  onRuleDataChange
}) => {
  const {
    form
  } = (0, _shared_imports.useForm)({
    defaultValue: initialState,
    options: {
      stripEmptyFields: false
    },
    schema: _schema.schema
  });
  const {
    getFormData,
    submit
  } = form;
  (0, _shared_imports.useFormData)({
    form,
    watch: ['from', 'interval'],
    onChange: data => {
      if (onRuleDataChange) {
        onRuleDataChange(data);
      }
    }
  });
  const handleSubmit = (0, _react.useCallback)(() => {
    if (onSubmit) {
      onSubmit();
    }
  }, [onSubmit]);
  const getData = (0, _react.useCallback)(async () => {
    const result = await submit();
    return result !== null && result !== void 0 && result.isValid ? result : {
      isValid: false,
      data: getFormData()
    };
  }, [getFormData, submit]);
  (0, _react.useEffect)(() => {
    let didCancel = false;
    if (setForm && !didCancel) {
      setForm(_types.RuleStep.scheduleRule, getData);
    }
    return () => {
      didCancel = true;
    };
  }, [getData, setForm]);
  return isReadOnlyView ? /*#__PURE__*/_react.default.createElement(_step_content_wrapper.StepContentWrapper, {
    addPadding: addPadding
  }, /*#__PURE__*/_react.default.createElement(_description_step.StepRuleDescription, {
    columns: descriptionColumns,
    schema: _schema.schema,
    data: initialState
  })) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_step_content_wrapper.StepContentWrapper, {
    addPadding: !isUpdateView
  }, /*#__PURE__*/_react.default.createElement(StyledForm, {
    form: form,
    "data-test-subj": "stepScheduleRule"
  }, /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    path: "interval",
    component: _schedule_item_form.ScheduleItem,
    componentProps: {
      idAria: 'detectionEngineStepScheduleRuleInterval',
      isDisabled: isLoading,
      dataTestSubj: 'detectionEngineStepScheduleRuleInterval',
      minimumValue: 1
    }
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    path: "from",
    component: _schedule_item_form.ScheduleItem,
    componentProps: {
      idAria: 'detectionEngineStepScheduleRuleFrom',
      isDisabled: isLoading,
      dataTestSubj: 'detectionEngineStepScheduleRuleFrom',
      minimumValue: 1
    }
  }))), !isUpdateView && /*#__PURE__*/_react.default.createElement(_next_step.NextStep, {
    dataTestSubj: "schedule-continue",
    onClick: handleSubmit,
    isDisabled: isLoading
  }));
};
const StepScheduleRule = /*#__PURE__*/(0, _react.memo)(StepScheduleRuleComponent);
exports.StepScheduleRule = StepScheduleRule;