"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RULE_SNOOZE_DESCRIPTION = exports.NO_ACTIONS_READ_PERMISSIONS = exports.COMPLETE_WITH_ENABLING = exports.COMPLETE_WITHOUT_ENABLING = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _kibana = require("../../../../common/lib/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const COMPLETE_WITHOUT_ENABLING = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepScheduleRule.completeWithoutEnablingTitle', {
  defaultMessage: 'Create rule without enabling it'
});
exports.COMPLETE_WITHOUT_ENABLING = COMPLETE_WITHOUT_ENABLING;
const COMPLETE_WITH_ENABLING = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepScheduleRule.completeWithEnablingTitle', {
  defaultMessage: 'Create & enable rule'
});
exports.COMPLETE_WITH_ENABLING = COMPLETE_WITH_ENABLING;
const NO_ACTIONS_READ_PERMISSIONS = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepRuleActions.noReadActionsPrivileges', {
  defaultMessage: 'Cannot create rule actions. You do not have "Read" permissions for the "Actions" plugin.'
});
exports.NO_ACTIONS_READ_PERMISSIONS = NO_ACTIONS_READ_PERMISSIONS;
const RULE_SNOOZE_DOCS_LINK_TEXT = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepRuleActions.docsLinkText', {
  defaultMessage: 'Learn more'
});
function RuleSnoozeDescription() {
  const {
    docLinks: {
      links: {
        securitySolution: {
          manageDetectionRules
        }
      }
    }
  } = (0, _kibana.useKibana)().services;
  const manageDetectionRulesSnoozeSection = `${manageDetectionRules}#edit-rules-settings`;
  return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.detectionEngine.createRule.stepRuleActions.snoozeDescription",
    defaultMessage: "Choose when to perform actions or snooze them. Notifications are not created for snoozed actions. {docs}.",
    values: {
      docs: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: manageDetectionRulesSnoozeSection,
        target: "_blank"
      }, RULE_SNOOZE_DOCS_LINK_TEXT)
    }
  });
}
const RULE_SNOOZE_DESCRIPTION = /*#__PURE__*/_react.default.createElement(RuleSnoozeDescription, null);
exports.RULE_SNOOZE_DESCRIPTION = RULE_SNOOZE_DESCRIPTION;