"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.stepActionsDefaultValue = exports.StepRuleActions = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _utils = require("../../../../../common/detection_engine/utils");
var _use_experimental_features = require("../../../../common/hooks/use_experimental_features");
var _response_actions_form = require("../../../../detection_engine/rule_response_actions/response_actions_form");
var _types = require("../../../pages/detection_engine/rules/types");
var _description_step = require("../description_step");
var _shared_imports = require("../../../../shared_imports");
var _step_content_wrapper = require("../step_content_wrapper");
var _rule_actions_field = require("../rule_actions_field");
var _kibana = require("../../../../common/lib/kibana");
var _get_schema = require("./get_schema");
var I18n = _interopRequireWildcard(require("./translations"));
var _constants = require("../../../../../common/constants");
var _rule_snooze_section = require("./rule_snooze_section");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const stepActionsDefaultValue = {
  enabled: true,
  actions: [],
  responseActions: [],
  kibanaSiemAppUrl: ''
};
exports.stepActionsDefaultValue = stepActionsDefaultValue;
const GhostFormField = () => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
const DisplayActionsHeader = () => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "Actions",
    id: "xpack.securitySolution.detectionEngine.rule.editRule.actionSectionsTitle"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }));
};
const StepRuleActionsComponent = ({
  ruleId,
  addPadding = false,
  defaultValues,
  isReadOnlyView,
  isLoading,
  isUpdateView = false,
  onSubmit,
  setForm,
  actionMessageParams,
  summaryActionMessageParams,
  ruleType
}) => {
  const {
    services: {
      application,
      triggersActionsUi: {
        actionTypeRegistry
      }
    }
  } = (0, _kibana.useKibana)();
  const responseActionsEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('responseActionsEnabled');
  const kibanaAbsoluteUrl = (0, _react.useMemo)(() => application.getUrlForApp(`${_constants.APP_UI_ID}`, {
    absolute: true
  }), [application]);
  const initialState = {
    ...(defaultValues !== null && defaultValues !== void 0 ? defaultValues : stepActionsDefaultValue),
    kibanaSiemAppUrl: kibanaAbsoluteUrl
  };
  const schema = (0, _react.useMemo)(() => (0, _get_schema.getSchema)({
    actionTypeRegistry
  }), [actionTypeRegistry]);
  const {
    form
  } = (0, _shared_imports.useForm)({
    defaultValue: initialState,
    options: {
      stripEmptyFields: false
    },
    schema
  });
  const {
    getFields,
    getFormData,
    submit
  } = form;
  const handleSubmit = (0, _react.useCallback)(enabled => {
    getFields().enabled.setValue(enabled);
    if (onSubmit) {
      onSubmit();
    }
  }, [getFields, onSubmit]);
  const getData = (0, _react.useCallback)(async () => {
    const result = await submit();
    return result !== null && result !== void 0 && result.isValid ? result : {
      isValid: false,
      data: getFormData()
    };
  }, [getFormData, submit]);
  (0, _react.useEffect)(() => {
    let didCancel = false;
    if (setForm && !didCancel) {
      setForm(_types.RuleStep.ruleActions, getData);
    }
    return () => {
      didCancel = true;
    };
  }, [getData, setForm]);
  const displayActionsOptions = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    path: "actions",
    component: _rule_actions_field.RuleActionsField,
    componentProps: {
      messageVariables: actionMessageParams,
      summaryMessageVariables: summaryActionMessageParams
    }
  })), [actionMessageParams, summaryActionMessageParams]);
  const displayResponseActionsOptions = (0, _react.useMemo)(() => {
    if ((0, _utils.isQueryRule)(ruleType)) {
      return /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseArray, {
        path: "responseActions",
        initialNumberOfItems: 0
      }, _response_actions_form.ResponseActionsForm);
    }
    return null;
  }, [ruleType]);
  // only display the actions dropdown if the user has "read" privileges for actions
  const displayActionsDropDown = (0, _react.useMemo)(() => {
    return application.capabilities.actions.show ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(DisplayActionsHeader, null), ruleId && /*#__PURE__*/_react.default.createElement(_rule_snooze_section.RuleSnoozeSection, {
      ruleId: ruleId
    }), displayActionsOptions, responseActionsEnabled && displayResponseActionsOptions, /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
      path: "kibanaSiemAppUrl",
      component: GhostFormField
    }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
      path: "enabled",
      component: GhostFormField
    })) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, I18n.NO_ACTIONS_READ_PERMISSIONS));
  }, [ruleId, application.capabilities.actions.show, displayActionsOptions, displayResponseActionsOptions, responseActionsEnabled]);
  if (isReadOnlyView) {
    return /*#__PURE__*/_react.default.createElement(_step_content_wrapper.StepContentWrapper, {
      addPadding: addPadding
    }, /*#__PURE__*/_react.default.createElement(_description_step.StepRuleDescription, {
      schema: schema,
      data: initialState,
      columns: "single"
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_step_content_wrapper.StepContentWrapper, {
    addPadding: !isUpdateView
  }, /*#__PURE__*/_react.default.createElement(_shared_imports.Form, {
    form: form,
    "data-test-subj": "stepRuleActions"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, null, displayActionsDropDown))), !isUpdateView && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "flexEnd",
    gutterSize: "xs",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: false,
    isDisabled: isLoading,
    isLoading: isLoading,
    onClick: () => handleSubmit(false),
    "data-test-subj": "create-enabled-false"
  }, I18n.COMPLETE_WITHOUT_ENABLING)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    isDisabled: isLoading,
    isLoading: isLoading,
    onClick: () => handleSubmit(true),
    "data-test-subj": "create-enable"
  }, I18n.COMPLETE_WITH_ENABLING)))));
};
const StepRuleActions = /*#__PURE__*/(0, _react.memo)(StepRuleActionsComponent);
exports.StepRuleActions = StepRuleActions;