"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSchema = void 0;
var _validate_rule_actions_field = require("../../../containers/detection_engine/rules/validate_rule_actions_field");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getSchema = ({
  actionTypeRegistry
}) => ({
  actions: {
    validations: [{
      // Debounced validator is necessary here to prevent error validation
      // flashing when first adding an action. Also prevents additional renders
      validator: (0, _validate_rule_actions_field.debouncedValidateRuleActionsField)(actionTypeRegistry)
    }]
  },
  responseActions: {},
  enabled: {},
  kibanaSiemAppUrl: {}
});
exports.getSchema = getSchema;