"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StepDefineRule = exports.MyLabelButton = void 0;
exports.aggregatableFields = aggregatableFields;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _usePrevious = _interopRequireDefault(require("react-use/lib/usePrevious"));
var _i18nReact = require("@kbn/i18n-react");
var _use_set_field_value_cb = require("../../../../common/utils/use_set_field_value_cb");
var _use_rule_from_timeline = require("../../../containers/detection_engine/rules/use_rule_from_timeline");
var _helpers = require("../../../../../common/machine_learning/helpers");
var _has_ml_admin_permissions = require("../../../../../common/machine_learning/has_ml_admin_permissions");
var _has_ml_license = require("../../../../../common/machine_learning/has_ml_license");
var _use_ml_capabilities = require("../../../../common/components/ml/hooks/use_ml_capabilities");
var _kibana = require("../../../../common/lib/kibana");
var _helpers2 = require("../../../../detection_engine/rule_creation_ui/pages/rule_creation/helpers");
var _types = require("../../../pages/detection_engine/rules/types");
var _description_step = require("../description_step");
var _query_bar = require("../query_bar");
var _select_rule_type = require("../select_rule_type");
var _anomaly_threshold_slider = require("../anomaly_threshold_slider");
var _ml_job_select = require("../ml_job_select");
var _pick_timeline = require("../pick_timeline");
var _step_content_wrapper = require("../step_content_wrapper");
var _next_step = require("../next_step");
var _threshold_input = require("../threshold_input");
var _suppression_info_icon = require("../suppression_info_icon");
var _shared_imports = require("../../../../shared_imports");
var _schema = require("./schema");
var _utils = require("./utils");
var i18n = _interopRequireWildcard(require("./translations"));
var _utils2 = require("../../../../../common/detection_engine/utils");
var _eql_query_bar = require("../eql_query_bar");
var _data_view_selector = require("../data_view_selector");
var _threatmatch_input = require("../threatmatch_input");
var _source = require("../../../../common/containers/source");
var _new_terms_fields = require("../new_terms_fields");
var _schedule_item_form = require("../schedule_item_form");
var _doc_link = require("../../../../common/components/links_to_docs/doc_link");
var _utils3 = require("../../../pages/detection_engine/rules/utils");
var _helpers3 = require("../rule_preview/helpers");
var _group_by_fields = require("../group_by_fields");
var _use_license = require("../../../../common/hooks/use_license");
var _rule_schema = require("../../../../../common/detection_engine/rule_schema");
var _duration_input = require("../duration_input");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CommonUseField = (0, _shared_imports.getUseField)({
  component: _shared_imports.Field
});
const StyledVisibleContainer = _styledComponents.default.div`
  display: ${props => props.isVisible ? 'block' : 'none'};
`;
const MyLabelButton = (0, _styledComponents.default)(_eui.EuiButtonEmpty)`
  height: 18px;
  font-size: 12px;

  .euiIcon {
    width: 14px;
    height: 14px;
  }
`;
exports.MyLabelButton = MyLabelButton;
MyLabelButton.defaultProps = {
  flush: 'right'
};
const RuleTypeEuiFormRow = (0, _styledComponents.default)(_eui.EuiFormRow).attrs(({
  $isVisible
}) => ({
  style: {
    display: $isVisible ? 'flex' : 'none'
  }
}))``;
const IntendedRuleTypeEuiFormRow = (0, _styledComponents.default)(RuleTypeEuiFormRow)`
  ${({
  theme
}) => `padding-left: ${theme.eui.euiSizeXL};`}
`;
const StepDefineRuleComponent = ({
  addPadding = false,
  defaultValues: initialState,
  descriptionColumns = 'singleSplit',
  isReadOnlyView,
  isLoading,
  isUpdateView = false,
  onSubmit,
  setForm,
  kibanaDataViews,
  indicesConfig,
  threatIndicesConfig,
  onRuleDataChange,
  onPreviewDisabledStateChange,
  defaultSavedQuery
}) => {
  const mlCapabilities = (0, _use_ml_capabilities.useMlCapabilities)();
  const [openTimelineSearch, setOpenTimelineSearch] = (0, _react.useState)(false);
  const [indexModified, setIndexModified] = (0, _react.useState)(false);
  const [threatIndexModified, setThreatIndexModified] = (0, _react.useState)(false);
  const [dataViewTitle, setDataViewTitle] = (0, _react.useState)();
  const license = (0, _use_license.useLicense)();
  const {
    form
  } = (0, _shared_imports.useForm)({
    defaultValue: initialState,
    options: {
      stripEmptyFields: false
    },
    schema: _schema.schema
  });
  const {
    getFields,
    getFormData,
    reset,
    setFieldValue,
    validate
  } = form;
  const [formData] = (0, _shared_imports.useFormData)({
    form,
    watch: ['index', 'ruleType', 'queryBar', 'threshold', 'dataViewId', 'threshold.field', 'threshold.value', 'threshold.cardinality.field', 'threshold.cardinality.value', 'threatIndex', 'threatMapping', 'machineLearningJobId', 'anomalyThreshold', 'dataSourceType', 'newTermsFields', 'historyWindowSize', 'shouldLoadQueryDynamically', 'groupByFields', 'groupByRadioSelection', 'groupByDuration.value', 'groupByDuration.unit', 'suppressionMissingFields'],
    onChange: data => {
      if (onRuleDataChange) {
        onRuleDataChange({
          ...data,
          eqlOptions: optionsSelected
        });
      }
    }
  });
  const {
    index: formIndex,
    ruleType: formRuleType,
    queryBar: formQuery,
    dataViewId: formDataViewId,
    threatIndex: formThreatIndex,
    threatMapping: formThreatMapping,
    machineLearningJobId: formMachineLearningJobId,
    dataSourceType: formDataSourceType,
    newTermsFields,
    shouldLoadQueryDynamically: formShouldLoadQueryDynamically,
    groupByFields
  } = formData;
  const [isQueryBarValid, setIsQueryBarValid] = (0, _react.useState)(false);
  const [isThreatQueryBarValid, setIsThreatQueryBarValid] = (0, _react.useState)(false);
  const index = formIndex || initialState.index;
  const dataViewId = formDataViewId || initialState.dataViewId;
  const threatIndex = formThreatIndex || initialState.threatIndex;
  const ruleType = formRuleType || initialState.ruleType;
  const dataSourceType = formDataSourceType || initialState.dataSourceType;
  const machineLearningJobId = formMachineLearningJobId !== null && formMachineLearningJobId !== void 0 ? formMachineLearningJobId : initialState.machineLearningJobId;
  const queryBar = formQuery !== null && formQuery !== void 0 ? formQuery : initialState.queryBar;
  const setRuleTypeCallback = (0, _use_set_field_value_cb.useSetFieldValueWithCallback)({
    field: 'ruleType',
    value: ruleType,
    setFieldValue
  });
  const [optionsSelected, setOptionsSelected] = (0, _react.useState)(initialState.eqlOptions || {});
  const handleSetRuleFromTimeline = (0, _react.useCallback)(({
    index: timelineIndex,
    queryBar: timelineQueryBar,
    eqlOptions
  }) => {
    const setQuery = () => {
      setFieldValue('index', timelineIndex);
      setFieldValue('queryBar', timelineQueryBar);
    };
    if (timelineQueryBar.query.language === 'eql') {
      setRuleTypeCallback('eql', setQuery);
      setOptionsSelected(prevOptions => ({
        ...prevOptions,
        ...(eqlOptions != null ? eqlOptions : {})
      }));
    } else {
      setQuery();
    }
  }, [setFieldValue, setRuleTypeCallback]);
  const {
    onOpenTimeline,
    loading: timelineQueryLoading
  } = (0, _use_rule_from_timeline.useRuleFromTimeline)(handleSetRuleFromTimeline);
  const [isPreviewValid, setIsPreviewValid] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    if (onPreviewDisabledStateChange) {
      onPreviewDisabledStateChange(!isPreviewValid);
    }
  }, [isPreviewValid, onPreviewDisabledStateChange]);
  (0, _react.useEffect)(() => {
    const isDisabled = (0, _helpers3.getIsRulePreviewDisabled)({
      ruleType,
      isQueryBarValid,
      isThreatQueryBarValid,
      index,
      dataViewId,
      dataSourceType,
      threatIndex,
      threatMapping: formThreatMapping,
      machineLearningJobId,
      queryBar,
      newTermsFields
    });
    setIsPreviewValid(!isDisabled);
  }, [dataSourceType, formDataViewId, newTermsFields, formQuery, dataViewId, formThreatMapping, index, queryBar, isQueryBarValid, isThreatQueryBarValid, machineLearningJobId, ruleType, threatIndex]);

  // if 'index' is selected, use these browser fields
  // otherwise use the dataview browserfields
  const previousRuleType = (0, _usePrevious.default)(ruleType);
  const [isIndexPatternLoading, {
    browserFields,
    indexPatterns: initIndexPattern
  }] = (0, _source.useFetchIndex)(index);
  const [indexPattern, setIndexPattern] = (0, _react.useState)(initIndexPattern);
  const {
    data
  } = (0, _kibana.useKibana)().services;

  // Why do we need this? to ensure the query bar auto-suggest gets the latest updates
  // when the index pattern changes
  // when we select new dataView
  // when we choose some other dataSourceType
  (0, _react.useEffect)(() => {
    if (dataSourceType === _types.DataSourceType.IndexPatterns) {
      if (!isIndexPatternLoading) {
        setIndexPattern(initIndexPattern);
      }
    }
    if (dataSourceType === _types.DataSourceType.DataView) {
      const fetchDataView = async () => {
        if (dataViewId != null) {
          const dv = await data.dataViews.get(dataViewId);
          setDataViewTitle(dv.title);
          setIndexPattern(dv);
        }
      };
      fetchDataView();
    }
  }, [dataSourceType, isIndexPatternLoading, data, dataViewId, initIndexPattern]);

  // Callback for when user toggles between Data Views and Index Patterns
  const onChangeDataSource = (0, _react.useCallback)(optionId => {
    form.setFieldValue('dataSourceType', optionId);
    form.getFields().index.reset({
      resetValue: false
    });
    form.getFields().dataViewId.reset({
      resetValue: false
    });
  }, [form]);
  const [aggFields, setAggregatableFields] = (0, _react.useState)([]);
  (0, _react.useEffect)(() => {
    const {
      fields
    } = indexPattern;
    /**
     * Typecasting to BrowserField because fields is
     * typed as DataViewFieldBase[] which does not have
     * the 'aggregatable' property, however the type is incorrect
     *
     * fields does contain elements with the aggregatable property.
     * We will need to determine where these types are defined and
     * figure out where the discrepency is.
     */
    setAggregatableFields(aggregatableFields(fields));
  }, [indexPattern]);
  const termsAggregationFields = (0, _react.useMemo)(() => (0, _utils.getTermsAggregationFields)(aggFields), [aggFields]);
  const [threatIndexPatternsLoading, {
    browserFields: threatBrowserFields,
    indexPatterns: threatIndexPatterns
  }] = (0, _source.useFetchIndex)(threatIndex);

  // reset form when rule type changes
  (0, _react.useEffect)(() => {
    reset({
      resetValues: false
    });
  }, [reset, ruleType]);
  (0, _react.useEffect)(() => {
    setIndexModified(!(0, _lodash.isEqual)(index, indicesConfig));
  }, [index, indicesConfig]);
  (0, _react.useEffect)(() => {
    setThreatIndexModified(!(0, _lodash.isEqual)(threatIndex, threatIndicesConfig));
  }, [threatIndex, threatIndicesConfig]);

  /**
   * When the user changes rule type to or from "threat_match" this will modify the
   * default "Custom query" string to either:
   *   * from '' to '*:*' if the type is switched to "threat_match"
   *   * from '*:*' back to '' if the type is switched back from "threat_match" to another one
   */
  (0, _react.useEffect)(() => {
    const {
      queryBar: currentQuery
    } = getFields();
    if (currentQuery == null) {
      return;
    }

    // NOTE: Below this code does two things that are worth commenting.

    // 1. If the user enters some text in the "Custom query" form field, we want
    // to keep it even if the user switched to another rule type. So we want to
    // be able to figure out if the field has been modified.
    // - The forms library provides properties (isPristine, isModified, isDirty)
    //   for that but they can't be used in our case: their values can be reset
    //   if you go to step 2 and then back to step 1 or the form is reset in another way.
    // - That's why we compare the actual value of the field with default ones.
    //   NOTE: It's important to do a deep object comparison by value.
    //   Don't do it by reference because the forms lib can change it internally.

    // 2. We call currentQuery.reset() in both cases to not trigger validation errors
    // as the user has not entered data into those areas yet.

    // If the user switched rule type to "threat_match" from any other one,
    // but hasn't changed the custom query used for normal rules (''),
    // we reset the custom query to the default used for "threat_match" rules ('*:*').
    if ((0, _utils2.isThreatMatchRule)(ruleType) && !(0, _utils2.isThreatMatchRule)(previousRuleType)) {
      if ((0, _lodash.isEqual)(currentQuery.value, _utils3.defaultCustomQuery.forNormalRules)) {
        currentQuery.reset({
          defaultValue: _utils3.defaultCustomQuery.forThreatMatchRules
        });
        return;
      }
    }

    // If the user switched rule type from "threat_match" to any other one,
    // but hasn't changed the custom query used for "threat_match" rules ('*:*'),
    // we reset the custom query to another default value ('').
    if (!(0, _utils2.isThreatMatchRule)(ruleType) && (0, _utils2.isThreatMatchRule)(previousRuleType)) {
      if ((0, _lodash.isEqual)(currentQuery.value, _utils3.defaultCustomQuery.forThreatMatchRules)) {
        currentQuery.reset({
          defaultValue: _utils3.defaultCustomQuery.forNormalRules
        });
      }
    }
  }, [ruleType, previousRuleType, getFields]);

  // if saved query failed to load:
  // - reset shouldLoadFormDynamically to false, as non existent query cannot be used for loading and execution
  const handleSavedQueryError = (0, _react.useCallback)(() => {
    if (!isQueryBarValid) {
      form.setFieldValue('shouldLoadQueryDynamically', false);
    }
  }, [isQueryBarValid, form]);
  const handleSubmit = (0, _react.useCallback)(() => {
    if (onSubmit) {
      onSubmit();
    }
  }, [onSubmit]);
  const getData = (0, _react.useCallback)(async () => {
    // validate doesn't return actual state of form
    // more details here: https://github.com/elastic/kibana/issues/144322#issuecomment-1321838136
    // wrapping in setTimeout is a workaround until solution within forms-lib can be found
    const isValid = await new Promise(resolve => {
      setTimeout(async () => {
        const valid = await validate();
        resolve(valid);
      }, 0);
    });
    return {
      isValid,
      data: {
        ...getFormData(),
        eqlOptions: optionsSelected
      }
    };
  }, [getFormData, optionsSelected, validate]);
  (0, _react.useEffect)(() => {
    let didCancel = false;
    if (setForm && !didCancel) {
      setForm(_types.RuleStep.defineRule, getData);
    }
    return () => {
      didCancel = true;
    };
  }, [getData, setForm]);
  const handleResetIndices = (0, _react.useCallback)(() => {
    const indexField = getFields().index;
    indexField.setValue(indicesConfig);
  }, [getFields, indicesConfig]);
  const handleResetThreatIndices = (0, _react.useCallback)(() => {
    const threatIndexField = getFields().threatIndex;
    threatIndexField.setValue(threatIndicesConfig);
  }, [getFields, threatIndicesConfig]);
  const handleOpenTimelineSearch = (0, _react.useCallback)(() => {
    setOpenTimelineSearch(true);
  }, []);
  const handleCloseTimelineSearch = (0, _react.useCallback)(() => {
    setOpenTimelineSearch(false);
  }, []);
  const ThresholdInputChildren = (0, _react.useCallback)(({
    thresholdField,
    thresholdValue,
    thresholdCardinalityField,
    thresholdCardinalityValue
  }) => /*#__PURE__*/_react.default.createElement(_threshold_input.ThresholdInput, {
    browserFields: aggFields,
    thresholdField: thresholdField,
    thresholdValue: thresholdValue,
    thresholdCardinalityField: thresholdCardinalityField,
    thresholdCardinalityValue: thresholdCardinalityValue
  }), [aggFields]);
  const ThreatMatchInputChildren = (0, _react.useCallback)(({
    threatMapping
  }) => /*#__PURE__*/_react.default.createElement(_threatmatch_input.ThreatMatchInput, {
    handleResetThreatIndices: handleResetThreatIndices,
    indexPatterns: indexPattern,
    threatBrowserFields: threatBrowserFields,
    threatIndexModified: threatIndexModified,
    threatIndexPatterns: threatIndexPatterns,
    threatIndexPatternsLoading: threatIndexPatternsLoading,
    threatMapping: threatMapping,
    onValidityChange: setIsThreatQueryBarValid
  }), [handleResetThreatIndices, indexPattern, threatBrowserFields, threatIndexModified, threatIndexPatterns, threatIndexPatternsLoading]);
  const GroupByChildren = (0, _react.useCallback)(({
    groupByRadioSelection,
    groupByDurationUnit,
    groupByDurationValue
  }) => /*#__PURE__*/_react.default.createElement(_eui.EuiRadioGroup, {
    disabled: !license.isAtLeast(_rule_schema.minimumLicenseForSuppression) || groupByFields == null || groupByFields.length === 0,
    idSelected: groupByRadioSelection.value,
    options: [{
      id: _types.GroupByOptions.PerRuleExecution,
      label: 'Per rule execution'
    }, {
      id: _types.GroupByOptions.PerTimePeriod,
      label: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, `Per time period`, /*#__PURE__*/_react.default.createElement(_duration_input.DurationInput, {
        durationValueField: groupByDurationValue,
        durationUnitField: groupByDurationUnit,
        isDisabled: !license.isAtLeast(_rule_schema.minimumLicenseForSuppression) || (groupByFields === null || groupByFields === void 0 ? void 0 : groupByFields.length) === 0 || groupByRadioSelection.value !== _types.GroupByOptions.PerTimePeriod,
        minimumValue: 1
      }))
    }],
    onChange: id => {
      groupByRadioSelection.setValue(id);
    },
    "data-test-subj": "groupByDurationOptions"
  }), [license, groupByFields]);
  const AlertsSuppressionMissingFields = (0, _react.useCallback)(({
    suppressionMissingFields
  }) => /*#__PURE__*/_react.default.createElement(_eui.EuiRadioGroup, {
    disabled: !license.isAtLeast(_rule_schema.minimumLicenseForSuppression) || groupByFields == null || groupByFields.length === 0,
    idSelected: suppressionMissingFields.value,
    options: [{
      id: _rule_schema.AlertSuppressionMissingFieldsStrategy.Suppress,
      label: i18n.ALERT_SUPPRESSION_MISSING_FIELDS_SUPPRESS_OPTION
    }, {
      id: _rule_schema.AlertSuppressionMissingFieldsStrategy.DoNotSuppress,
      label: i18n.ALERT_SUPPRESSION_MISSING_FIELDS_DO_NOT_SUPPRESS_OPTION
    }],
    onChange: id => {
      suppressionMissingFields.setValue(id);
    },
    "data-test-subj": "suppressionMissingFieldsOptions"
  }), [license, groupByFields]);
  const dataViewIndexPatternToggleButtonOptions = (0, _react.useMemo)(() => [{
    id: _types.DataSourceType.IndexPatterns,
    label: _i18n.i18n.translate('xpack.securitySolution.ruleDefine.indexTypeSelect.indexPattern', {
      defaultMessage: 'Index Patterns'
    }),
    iconType: dataSourceType === _types.DataSourceType.IndexPatterns ? 'checkInCircleFilled' : 'empty',
    'data-test-subj': `rule-index-toggle-${_types.DataSourceType.IndexPatterns}`
  }, {
    id: _types.DataSourceType.DataView,
    label: _i18n.i18n.translate('xpack.securitySolution.ruleDefine.indexTypeSelect.dataView', {
      defaultMessage: 'Data View'
    }),
    iconType: dataSourceType === _types.DataSourceType.DataView ? 'checkInCircleFilled' : 'empty',
    'data-test-subj': `rule-index-toggle-${_types.DataSourceType.DataView}`
  }], [dataSourceType]);
  const DataViewSelectorMemo = (0, _react.useMemo)(() => {
    return kibanaDataViews == null || Object.keys(kibanaDataViews).length === 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "l"
    }) : /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
      key: "DataViewSelector",
      path: "dataViewId",
      component: _data_view_selector.DataViewSelector,
      componentProps: {
        kibanaDataViews
      }
    });
  }, [kibanaDataViews]);
  const DataSource = (0, _react.useMemo)(() => {
    return /*#__PURE__*/_react.default.createElement(RuleTypeEuiFormRow, {
      label: i18n.SOURCE,
      $isVisible: true,
      fullWidth: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      gutterSize: "s",
      "data-test-subj": "dataViewIndexPatternButtonGroupFlexGroup"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.dataViewSelectorText1",
      defaultMessage: "Use Kibana "
    }), /*#__PURE__*/_react.default.createElement(_doc_link.DocLink, {
      guidePath: "kibana",
      docPath: "data-views.html",
      linkText: "Data Views"
    }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.dataViewSelectorText2",
      defaultMessage: " or specify individual "
    }), /*#__PURE__*/_react.default.createElement(_doc_link.DocLink, {
      guidePath: "kibana",
      docPath: "index-patterns-api-create.html",
      linkText: "index patterns"
    }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.dataViewSelectorText3",
      defaultMessage: " as your rule's data source to be searched."
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(RuleTypeEuiFormRow, {
      $isVisible: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
      isFullWidth: true,
      legend: "Rule index pattern or data view selector",
      "data-test-subj": "dataViewIndexPatternButtonGroup",
      idSelected: dataSourceType,
      onChange: onChangeDataSource,
      options: dataViewIndexPatternToggleButtonOptions,
      color: "primary"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(StyledVisibleContainer, {
      isVisible: dataSourceType === _types.DataSourceType.DataView
    }, DataViewSelectorMemo), /*#__PURE__*/_react.default.createElement(StyledVisibleContainer, {
      isVisible: dataSourceType === _types.DataSourceType.IndexPatterns
    }, /*#__PURE__*/_react.default.createElement(CommonUseField, {
      path: "index",
      config: {
        ...(0, _lodash.omit)(_schema.schema.index, 'label'),
        labelAppend: indexModified ? /*#__PURE__*/_react.default.createElement(MyLabelButton, {
          onClick: handleResetIndices,
          iconType: "refresh"
        }, i18n.RESET_DEFAULT_INDEX) : null
      },
      componentProps: {
        idAria: 'detectionEngineStepDefineRuleIndices',
        'data-test-subj': 'detectionEngineStepDefineRuleIndices',
        euiFieldProps: {
          fullWidth: true,
          placeholder: '',
          isDisabled: timelineQueryLoading,
          isLoading: timelineQueryLoading
        }
      }
    })))));
  }, [timelineQueryLoading, dataSourceType, onChangeDataSource, dataViewIndexPatternToggleButtonOptions, DataViewSelectorMemo, indexModified, handleResetIndices]);
  const QueryBarMemo = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    key: "QueryBarDefineRule",
    path: "queryBar",
    config: {
      ..._schema.schema.queryBar,
      label: i18n.QUERY_BAR_LABEL,
      labelAppend: /*#__PURE__*/_react.default.createElement(MyLabelButton, {
        "data-test-subj": "importQueryFromSavedTimeline",
        onClick: handleOpenTimelineSearch,
        disabled: formShouldLoadQueryDynamically
      }, i18n.IMPORT_TIMELINE_QUERY)
    },
    component: _query_bar.QueryBarDefineRule,
    componentProps: {
      browserFields,
      idAria: 'detectionEngineStepDefineRuleQueryBar',
      indexPattern,
      isDisabled: isLoading || formShouldLoadQueryDynamically || timelineQueryLoading,
      resetToSavedQuery: formShouldLoadQueryDynamically,
      isLoading: isIndexPatternLoading || timelineQueryLoading,
      dataTestSubj: 'detectionEngineStepDefineRuleQueryBar',
      openTimelineSearch,
      onValidityChange: setIsQueryBarValid,
      onCloseTimelineSearch: handleCloseTimelineSearch,
      onSavedQueryError: handleSavedQueryError,
      defaultSavedQuery,
      onOpenTimeline
    }
  }), [handleOpenTimelineSearch, formShouldLoadQueryDynamically, browserFields, indexPattern, isLoading, timelineQueryLoading, isIndexPatternLoading, openTimelineSearch, handleCloseTimelineSearch, handleSavedQueryError, defaultSavedQuery, onOpenTimeline]);
  const onOptionsChange = (0, _react.useCallback)((field, value) => {
    setOptionsSelected(prevOptions => ({
      ...prevOptions,
      [field]: value
    }));
  }, []);
  const optionsData = (0, _react.useMemo)(() => (0, _lodash.isEmpty)(indexPattern.fields) ? {
    keywordFields: [],
    dateFields: [],
    nonDateFields: []
  } : {
    keywordFields: indexPattern.fields.filter(f => {
      var _f$esTypes;
      return (_f$esTypes = f.esTypes) === null || _f$esTypes === void 0 ? void 0 : _f$esTypes.includes('keyword');
    }).map(f => ({
      label: f.name
    })),
    dateFields: indexPattern.fields.filter(f => f.type === 'date').map(f => ({
      label: f.name
    })),
    nonDateFields: indexPattern.fields.filter(f => f.type !== 'date').map(f => ({
      label: f.name
    }))
  }, [indexPattern]);
  const dataForDescription = (0, _helpers2.getStepDataDataSource)(initialState);
  if (dataSourceType === _types.DataSourceType.DataView) {
    dataForDescription.dataViewTitle = dataViewTitle;
  }
  return isReadOnlyView ? /*#__PURE__*/_react.default.createElement(_step_content_wrapper.StepContentWrapper, {
    "data-test-subj": "definitionRule",
    addPadding: addPadding
  }, /*#__PURE__*/_react.default.createElement(_description_step.StepRuleDescription, {
    columns: descriptionColumns,
    indexPatterns: indexPattern,
    schema: (0, _helpers2.filterRuleFieldsForType)(_schema.schema, ruleType),
    data: (0, _helpers2.filterRuleFieldsForType)(dataForDescription, ruleType)
  })) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_step_content_wrapper.StepContentWrapper, {
    addPadding: !isUpdateView
  }, /*#__PURE__*/_react.default.createElement(_shared_imports.Form, {
    form: form,
    "data-test-subj": "stepDefineRule"
  }, /*#__PURE__*/_react.default.createElement(StyledVisibleContainer, {
    isVisible: false
  }, /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    path: "dataSourceType",
    componentProps: {
      euiFieldProps: {
        fullWidth: true,
        placeholder: ''
      }
    }
  })), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    path: "ruleType",
    component: _select_rule_type.SelectRuleType,
    componentProps: {
      describedByIds: ['detectionEngineStepDefineRuleType'],
      isUpdateView,
      hasValidLicense: (0, _has_ml_license.hasMlLicense)(mlCapabilities),
      isMlAdmin: (0, _has_ml_admin_permissions.hasMlAdminPermissions)(mlCapabilities)
    }
  }), /*#__PURE__*/_react.default.createElement(RuleTypeEuiFormRow, {
    $isVisible: !(0, _helpers.isMlRule)(ruleType),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), DataSource, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), (0, _utils2.isEqlRule)(ruleType) ? /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    key: "EqlQueryBar",
    path: "queryBar",
    component: _eql_query_bar.EqlQueryBar,
    componentProps: {
      optionsData,
      optionsSelected,
      isSizeOptionDisabled: true,
      onOptionsChange,
      onValidityChange: setIsQueryBarValid,
      idAria: 'detectionEngineStepDefineRuleEqlQueryBar',
      isDisabled: isLoading,
      isLoading: isIndexPatternLoading,
      indexPattern,
      showFilterBar: true,
      // isLoading: indexPatternsLoading,
      dataTestSubj: 'detectionEngineStepDefineRuleEqlQueryBar'
    },
    config: {
      ..._schema.schema.queryBar,
      label: i18n.EQL_QUERY_BAR_LABEL
    }
  }) : QueryBarMemo)), (0, _utils2.isQueryRule)(ruleType) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(RuleTypeEuiFormRow, {
    label: i18n.SAVED_QUERY_FORM_ROW_LABEL,
    $isVisible: Boolean((queryBar === null || queryBar === void 0 ? void 0 : queryBar.saved_id) && (queryBar === null || queryBar === void 0 ? void 0 : queryBar.title)),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(CommonUseField, {
    path: "shouldLoadQueryDynamically",
    componentProps: {
      idAria: 'detectionEngineStepDefineRuleShouldLoadQueryDynamically',
      'data-test-subj': 'detectionEngineStepDefineRuleShouldLoadQueryDynamically',
      euiFieldProps: {
        disabled: isLoading,
        label: queryBar !== null && queryBar !== void 0 && queryBar.title ? i18n.getSavedQueryCheckboxLabel(queryBar.title) : undefined
      }
    }
  }))), /*#__PURE__*/_react.default.createElement(RuleTypeEuiFormRow, {
    $isVisible: (0, _utils2.isQueryRule)(ruleType),
    "data-test-subj": "alertSuppressionInput"
  }, /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    path: "groupByFields",
    component: _group_by_fields.GroupByFields,
    componentProps: {
      browserFields: termsAggregationFields,
      isDisabled: !license.isAtLeast(_rule_schema.minimumLicenseForSuppression) && initialState.groupByFields.length === 0
    }
  })), /*#__PURE__*/_react.default.createElement(IntendedRuleTypeEuiFormRow, {
    $isVisible: (0, _utils2.isQueryRule)(ruleType),
    "data-test-subj": "alertSuppressionDuration"
  }, /*#__PURE__*/_react.default.createElement(_shared_imports.UseMultiFields, {
    fields: {
      groupByRadioSelection: {
        path: 'groupByRadioSelection'
      },
      groupByDurationValue: {
        path: 'groupByDuration.value'
      },
      groupByDurationUnit: {
        path: 'groupByDuration.unit'
      }
    }
  }, GroupByChildren)), /*#__PURE__*/_react.default.createElement(IntendedRuleTypeEuiFormRow, {
    $isVisible: (0, _utils2.isQueryRule)(ruleType),
    "data-test-subj": "alertSuppressionMissingFields",
    label: /*#__PURE__*/_react.default.createElement("span", null, i18n.ALERT_SUPPRESSION_MISSING_FIELDS_FORM_ROW_LABEL, " ", /*#__PURE__*/_react.default.createElement(_suppression_info_icon.SuppressionInfoIcon, null)),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_shared_imports.UseMultiFields, {
    fields: {
      suppressionMissingFields: {
        path: 'suppressionMissingFields'
      }
    }
  }, AlertsSuppressionMissingFields)), /*#__PURE__*/_react.default.createElement(RuleTypeEuiFormRow, {
    $isVisible: (0, _helpers.isMlRule)(ruleType),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    path: "machineLearningJobId",
    component: _ml_job_select.MlJobSelect,
    componentProps: {
      describedByIds: ['detectionEngineStepDefineRulemachineLearningJobId']
    }
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    path: "anomalyThreshold",
    component: _anomaly_threshold_slider.AnomalyThresholdSlider,
    componentProps: {
      describedByIds: ['detectionEngineStepDefineRuleAnomalyThreshold']
    }
  }))), /*#__PURE__*/_react.default.createElement(RuleTypeEuiFormRow, {
    $isVisible: (0, _utils2.isThresholdRule)(ruleType),
    "data-test-subj": "thresholdInput",
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_shared_imports.UseMultiFields, {
    fields: {
      thresholdField: {
        path: 'threshold.field'
      },
      thresholdValue: {
        path: 'threshold.value'
      },
      thresholdCardinalityField: {
        path: 'threshold.cardinality.field'
      },
      thresholdCardinalityValue: {
        path: 'threshold.cardinality.value'
      }
    }
  }, ThresholdInputChildren))), /*#__PURE__*/_react.default.createElement(RuleTypeEuiFormRow, {
    $isVisible: (0, _utils2.isThreatMatchRule)(ruleType),
    "data-test-subj": "threatMatchInput",
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_shared_imports.UseMultiFields, {
    fields: {
      threatMapping: {
        path: 'threatMapping'
      }
    }
  }, ThreatMatchInputChildren))), /*#__PURE__*/_react.default.createElement(RuleTypeEuiFormRow, {
    $isVisible: (0, _utils2.isNewTermsRule)(ruleType),
    "data-test-subj": "newTermsInput",
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    path: "newTermsFields",
    component: _new_terms_fields.NewTermsFields,
    componentProps: {
      browserFields: termsAggregationFields
    }
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    path: "historyWindowSize",
    component: _schedule_item_form.ScheduleItem,
    componentProps: {
      idAria: 'detectionEngineStepDefineRuleHistoryWindowSize',
      dataTestSubj: 'detectionEngineStepDefineRuleHistoryWindowSize',
      timeTypes: ['m', 'h', 'd']
    }
  }))), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    path: "timeline",
    component: _pick_timeline.PickTimeline,
    componentProps: {
      idAria: 'detectionEngineStepDefineRuleTimeline',
      isDisabled: isLoading,
      dataTestSubj: 'detectionEngineStepDefineRuleTimeline'
    }
  }))), !isUpdateView && /*#__PURE__*/_react.default.createElement(_next_step.NextStep, {
    dataTestSubj: "define-continue",
    onClick: handleSubmit,
    isDisabled: isLoading
  }));
};
const StepDefineRule = /*#__PURE__*/(0, _react.memo)(StepDefineRuleComponent);
exports.StepDefineRule = StepDefineRule;
function aggregatableFields(browserFields) {
  return browserFields.filter(field => field.aggregatable === true);
}