"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StepAboutRuleToggleDetails = void 0;
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _css = require("@emotion/css");
var _header_section = require("../../../../common/components/header_section");
var _markdown_editor = require("../../../../common/components/markdown_editor");
var i18n = _interopRequireWildcard(require("./translations"));
var _step_about_rule = require("../step_about_rule");
var _styles = require("./styles");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const detailsOption = {
  id: 'details',
  label: i18n.ABOUT_PANEL_DETAILS_TAB,
  'data-test-subj': 'stepAboutDetailsToggle-details'
};
const notesOption = {
  id: 'notes',
  label: i18n.ABOUT_PANEL_NOTES_TAB,
  'data-test-subj': 'stepAboutDetailsToggle-notes'
};
const setupOption = {
  id: 'setup',
  label: i18n.ABOUT_PANEL_SETUP_TAB,
  'data-test-subj': 'stepAboutDetailsToggle-setup'
};
const StepAboutRuleToggleDetailsComponent = ({
  stepData,
  stepDataDetails,
  loading
}) => {
  const [selectedToggleOption, setToggleOption] = (0, _react.useState)('details');
  const [aboutPanelHeight, setAboutPanelHeight] = (0, _react.useState)(0);
  const onResize = (0, _react.useCallback)(e => {
    setAboutPanelHeight(e.height);
  }, [setAboutPanelHeight]);
  const toggleOptions = (0, _react.useMemo)(() => {
    const notesExist = !(0, _lodash.isEmpty)(stepDataDetails === null || stepDataDetails === void 0 ? void 0 : stepDataDetails.note) && (stepDataDetails === null || stepDataDetails === void 0 ? void 0 : stepDataDetails.note.trim()) !== '';
    const setupExists = !(0, _lodash.isEmpty)(stepDataDetails === null || stepDataDetails === void 0 ? void 0 : stepDataDetails.setup) && (stepDataDetails === null || stepDataDetails === void 0 ? void 0 : stepDataDetails.setup.trim()) !== '';
    return [...(notesExist || setupExists ? [detailsOption] : []), ...(notesExist ? [notesOption] : []), ...(setupExists ? [setupOption] : [])];
  }, [stepDataDetails]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    className: (0, _css.css)`
        position: relative;
      `
  }, loading && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    size: "xs",
    color: "accent",
    position: "absolute"
  }), /*#__PURE__*/_react.default.createElement(_header_section.HeaderSection, {
    title: i18n.ABOUT_TEXT
  })), stepData != null && stepDataDetails != null && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    direction: "column",
    className: _styles.fullHeight
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    key: "header"
  }, /*#__PURE__*/_react.default.createElement(_header_section.HeaderSection, {
    title: i18n.ABOUT_TEXT
  }, toggleOptions.length > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    options: toggleOptions,
    idSelected: selectedToggleOption,
    onChange: val => {
      setToggleOption(val);
    },
    "data-test-subj": "stepAboutDetailsToggle",
    legend: i18n.ABOUT_CONTROL_LEGEND
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: "details"
  }, selectedToggleOption === 'details' && /*#__PURE__*/_react.default.createElement(_eui.EuiResizeObserver, {
    "data-test-subj": "stepAboutDetailsContent",
    onResize: onResize
  }, resizeRef => /*#__PURE__*/_react.default.createElement("div", {
    ref: resizeRef,
    className: _styles.fullHeight
  }, /*#__PURE__*/_react.default.createElement(VerticalOverflowContainer, {
    maxHeight: 120
  }, /*#__PURE__*/_react.default.createElement(VerticalOverflowContent, {
    maxHeight: 120
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    "data-test-subj": "stepAboutRuleDetailsToggleDescriptionText"
  }, stepDataDetails.description))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_step_about_rule.StepAboutRule, {
    descriptionColumns: "singleSplit",
    isReadOnlyView: true,
    isLoading: false,
    defaultValues: stepData
  }))), selectedToggleOption === 'notes' && /*#__PURE__*/_react.default.createElement(VerticalOverflowContainer, {
    "data-test-subj": "stepAboutDetailsNoteContent",
    maxHeight: aboutPanelHeight
  }, /*#__PURE__*/_react.default.createElement(VerticalOverflowContent, {
    maxHeight: aboutPanelHeight
  }, /*#__PURE__*/_react.default.createElement(_markdown_editor.MarkdownRenderer, null, stepDataDetails.note))), selectedToggleOption === 'setup' && /*#__PURE__*/_react.default.createElement(VerticalOverflowContainer, {
    "data-test-subj": "stepAboutDetailsSetupContent",
    maxHeight: aboutPanelHeight
  }, /*#__PURE__*/_react.default.createElement(VerticalOverflowContent, {
    maxHeight: aboutPanelHeight
  }, /*#__PURE__*/_react.default.createElement(_markdown_editor.MarkdownRenderer, null, stepDataDetails.setup))))));
};
const StepAboutRuleToggleDetails = /*#__PURE__*/(0, _react.memo)(StepAboutRuleToggleDetailsComponent);
exports.StepAboutRuleToggleDetails = StepAboutRuleToggleDetails;
function VerticalOverflowContainer({
  maxHeight,
  'data-test-subj': dataTestSubject,
  children
}) {
  return /*#__PURE__*/_react.default.createElement("div", {
    className: (0, _css.css)`
        max-height: ${maxHeight}px;
        overflow-y: hidden;
        word-break: break-word;
      `,
    "data-test-subj": dataTestSubject
  }, children);
}
function VerticalOverflowContent({
  maxHeight,
  children
}) {
  return /*#__PURE__*/_react.default.createElement("div", {
    className: `eui-yScroll ${(0, _css.css)`
        max-height: ${maxHeight}px;
      `}`
  }, children);
}