"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.severityOptions = exports.defaultRiskScoreBySeverity = exports.RISK_SCORE_MEDIUM = exports.RISK_SCORE_LOW = exports.RISK_SCORE_HIGH = exports.RISK_SCORE_CRITICAL = exports.RISK_COLOR_MEDIUM = exports.RISK_COLOR_LOW = exports.RISK_COLOR_HIGH = exports.RISK_COLOR_CRITICAL = void 0;
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
var _uiTheme = require("@kbn/ui-theme");
var I18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StyledEuiHealth = (0, _styledComponents.default)(_eui.EuiHealth)`
  line-height: inherit;
`;
const RISK_COLOR_LOW = _uiTheme.euiLightVars.euiColorVis0;
exports.RISK_COLOR_LOW = RISK_COLOR_LOW;
const RISK_COLOR_MEDIUM = _uiTheme.euiLightVars.euiColorVis5;
exports.RISK_COLOR_MEDIUM = RISK_COLOR_MEDIUM;
const RISK_COLOR_HIGH = _uiTheme.euiLightVars.euiColorVis7;
exports.RISK_COLOR_HIGH = RISK_COLOR_HIGH;
const RISK_COLOR_CRITICAL = _uiTheme.euiLightVars.euiColorVis9;
exports.RISK_COLOR_CRITICAL = RISK_COLOR_CRITICAL;
const RISK_SCORE_LOW = 21;
exports.RISK_SCORE_LOW = RISK_SCORE_LOW;
const RISK_SCORE_MEDIUM = 47;
exports.RISK_SCORE_MEDIUM = RISK_SCORE_MEDIUM;
const RISK_SCORE_HIGH = 73;
exports.RISK_SCORE_HIGH = RISK_SCORE_HIGH;
const RISK_SCORE_CRITICAL = 99;
exports.RISK_SCORE_CRITICAL = RISK_SCORE_CRITICAL;
const severityOptions = [{
  value: 'low',
  inputDisplay: /*#__PURE__*/_react.default.createElement(StyledEuiHealth, {
    color: RISK_COLOR_LOW
  }, I18n.LOW)
}, {
  value: 'medium',
  inputDisplay: /*#__PURE__*/_react.default.createElement(StyledEuiHealth, {
    color: RISK_COLOR_MEDIUM
  }, I18n.MEDIUM)
}, {
  value: 'high',
  inputDisplay: /*#__PURE__*/_react.default.createElement(StyledEuiHealth, {
    color: RISK_COLOR_HIGH
  }, I18n.HIGH)
}, {
  value: 'critical',
  inputDisplay: /*#__PURE__*/_react.default.createElement(StyledEuiHealth, {
    color: RISK_COLOR_CRITICAL
  }, I18n.CRITICAL)
}];
exports.severityOptions = severityOptions;
const defaultRiskScoreBySeverity = {
  low: RISK_SCORE_LOW,
  medium: RISK_SCORE_MEDIUM,
  high: RISK_SCORE_HIGH,
  critical: RISK_SCORE_CRITICAL
};
exports.defaultRiskScoreBySeverity = defaultRiskScoreBySeverity;