"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SeverityField = void 0;
var _eui = require("@elastic/eui");
var _fp = require("lodash/fp");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _securitysolutionAutocomplete = require("@kbn/securitysolution-autocomplete");
var _kibana = require("../../../../common/lib/kibana");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NestedContent = _styledComponents.default.div`
  margin-left: 24px;
`;
const EuiFlexItemComboBoxColumn = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  max-width: 376px;
`;
const EuiFlexItemIconColumn = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  width: 20px;
`;
const EuiFlexItemSeverityColumn = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  width: 80px;
`;
const SeverityField = ({
  dataTestSubj,
  field,
  idAria,
  indices,
  isDisabled,
  options
}) => {
  const {
    services
  } = (0, _kibana.useKibana)();
  const {
    value,
    isMappingChecked,
    mapping
  } = field.value;
  const {
    setValue
  } = field;
  const handleFieldValueChange = (0, _react.useCallback)((newMappingItems, index) => {
    setValue({
      value,
      isMappingChecked,
      mapping: [...mapping.slice(0, index), ...newMappingItems, ...mapping.slice(index + 1)]
    });
  }, [value, isMappingChecked, mapping, setValue]);
  const handleFieldChange = (0, _react.useCallback)((index, severity, [newField]) => {
    var _newField$name;
    const newMappingItems = [{
      ...mapping[index],
      field: (_newField$name = newField === null || newField === void 0 ? void 0 : newField.name) !== null && _newField$name !== void 0 ? _newField$name : '',
      value: newField != null ? mapping[index].value : '',
      operator: 'equals',
      severity
    }];
    handleFieldValueChange(newMappingItems, index);
  }, [mapping, handleFieldValueChange]);
  const handleDefaultSeverityChange = (0, _react.useCallback)(newValue => {
    setValue({
      value: newValue,
      isMappingChecked,
      mapping
    });
  }, [isMappingChecked, mapping, setValue]);
  const handleFieldMatchValueChange = (0, _react.useCallback)((index, severity, newMatchValue) => {
    const newMappingItems = [{
      ...mapping[index],
      field: mapping[index].field,
      value: mapping[index].field != null && mapping[index].field !== '' ? newMatchValue : '',
      operator: 'equals',
      severity
    }];
    handleFieldValueChange(newMappingItems, index);
  }, [mapping, handleFieldValueChange]);
  const handleSeverityMappingChecked = (0, _react.useCallback)(() => {
    setValue({
      value,
      mapping: [...mapping],
      isMappingChecked: !isMappingChecked
    });
  }, [isMappingChecked, mapping, value, setValue]);
  const severityLabel = (0, _react.useMemo)(() => {
    return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, i18n.SEVERITY)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xs"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: 'xs'
    }, i18n.SEVERITY_DESCRIPTION));
  }, []);
  const severityMappingLabel = (0, _react.useMemo)(() => {
    return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "s",
      onClick: !isDisabled ? handleSeverityMappingChecked : _fp.noop
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
      id: `severity-mapping-override`,
      checked: isMappingChecked,
      disabled: isDisabled,
      onChange: handleSeverityMappingChecked
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, i18n.SEVERITY_MAPPING)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xs"
    }), /*#__PURE__*/_react.default.createElement(NestedContent, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: 'xs'
    }, i18n.SEVERITY_MAPPING_DESCRIPTION)));
  }, [handleSeverityMappingChecked, isDisabled, isMappingChecked]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: 'column'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: severityLabel,
    labelAppend: field.labelAppend,
    helpText: field.helpText,
    error: 'errorMessage',
    isInvalid: false,
    fullWidth: true,
    "data-test-subj": "detectionEngineStepAboutRuleSeverity",
    describedByIds: ['detectionEngineStepAboutRuleSeverity']
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    fullWidth: false,
    disabled: false,
    valueOfSelected: value,
    onChange: handleDefaultSeverityChange,
    options: options,
    "data-test-subj": "select"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: severityMappingLabel,
    labelAppend: field.labelAppend,
    helpText: isMappingChecked ? /*#__PURE__*/_react.default.createElement(NestedContent, null, i18n.SEVERITY_MAPPING_DETAILS) : '',
    error: 'errorMessage',
    isInvalid: false,
    fullWidth: true,
    "data-test-subj": `${dataTestSubj}-severityOverride`,
    describedByIds: idAria ? [idAria] : undefined
  }, /*#__PURE__*/_react.default.createElement(NestedContent, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), isMappingChecked && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: 'column',
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(EuiFlexItemComboBoxColumn, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormLabel, null, i18n.SOURCE_FIELD)), /*#__PURE__*/_react.default.createElement(EuiFlexItemComboBoxColumn, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormLabel, null, i18n.SOURCE_VALUE)), /*#__PURE__*/_react.default.createElement(EuiFlexItemIconColumn, {
    grow: false
  }), /*#__PURE__*/_react.default.createElement(EuiFlexItemSeverityColumn, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormLabel, null, i18n.DEFAULT_SEVERITY)))), mapping.map((severityMappingItem, index) => {
    var _options$find;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: `${severityMappingItem.severity}-${index}`
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      "data-test-subj": "severityOverrideRow",
      alignItems: "center",
      gutterSize: "s"
    }, /*#__PURE__*/_react.default.createElement(EuiFlexItemComboBoxColumn, null, /*#__PURE__*/_react.default.createElement(_securitysolutionAutocomplete.FieldComponent, {
      placeholder: '',
      selectedField: getFieldTypeByMapping(severityMappingItem, indices),
      isLoading: false,
      isDisabled: isDisabled,
      isClearable: false,
      indexPattern: indices,
      onChange: handleFieldChange.bind(null, index, severityMappingItem.severity),
      "data-test-subj": `detectionEngineStepAboutRuleSeverityMappingField-${severityMappingItem.severity}-${index}`,
      "aria-label": `detectionEngineStepAboutRuleSeverityMappingField-${severityMappingItem.severity}-${index}`
    })), /*#__PURE__*/_react.default.createElement(EuiFlexItemComboBoxColumn, null, /*#__PURE__*/_react.default.createElement(_securitysolutionAutocomplete.AutocompleteFieldMatchComponent, {
      autocompleteService: services.unifiedSearch.autocomplete,
      placeholder: '',
      selectedField: getFieldTypeByMapping(severityMappingItem, indices),
      selectedValue: severityMappingItem.value,
      isClearable: false,
      isDisabled: isDisabled,
      isLoading: false,
      indexPattern: indices,
      onChange: handleFieldMatchValueChange.bind(null, index, severityMappingItem.severity),
      "data-test-subj": `detectionEngineStepAboutRuleSeverityMappingValue-${severityMappingItem.severity}-${index}`,
      "aria-label": `detectionEngineStepAboutRuleSeverityMappingValue-${severityMappingItem.severity}-${index}`
    })), /*#__PURE__*/_react.default.createElement(EuiFlexItemIconColumn, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: 'sortRight'
    })), /*#__PURE__*/_react.default.createElement(EuiFlexItemSeverityColumn, {
      grow: false
    }, (_options$find = options.find(o => o.value === severityMappingItem.severity)) === null || _options$find === void 0 ? void 0 : _options$find.inputDisplay)));
  }))))));
};

/**
 * Looks for field metadata (DataViewFieldBase) in existing index pattern.
 * If specified field doesn't exist, returns a stub DataViewFieldBase created based on the mapping --
 * because the field might not have been indexed yet, but we still need to display the mapping.
 *
 * @param mapping Mapping of a specified field name + value to a certain severity value.
 * @param pattern Existing index pattern.
 */
exports.SeverityField = SeverityField;
const getFieldTypeByMapping = (mapping, pattern) => {
  const {
    field
  } = mapping;
  const [knownFieldType] = pattern.fields.filter(({
    name
  }) => field === name);
  return knownFieldType !== null && knownFieldType !== void 0 ? knownFieldType : {
    name: field,
    type: 'string'
  };
};