"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleSwitchComponent = exports.RuleSwitch = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _request_schema = require("../../../../../common/detection_engine/rule_management/api/rules/bulk_actions/request_schema");
var _user_actions = require("../../../../common/lib/apm/user_actions");
var _use_start_transaction = require("../../../../common/lib/apm/use_start_transaction");
var _use_execute_bulk_action = require("../../../../detection_engine/rule_management/logic/bulk_actions/use_execute_bulk_action");
var _rules_table_context = require("../../../../detection_engine/rule_management_ui/components/rules_table/rules_table/rules_table_context");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StaticSwitch = (0, _styledComponents.default)(_eui.EuiSwitch)`
  .euiSwitch__thumb,
  .euiSwitch__icon {
    transition: none;
  }
`;
StaticSwitch.displayName = 'StaticSwitch';
/**
 * Basic switch component for displaying loader when enabled/disabled
 */
const RuleSwitchComponent = ({
  id,
  isDisabled,
  isLoading,
  enabled,
  startMlJobsIfNeeded,
  onChange
}) => {
  const [myIsLoading, setMyIsLoading] = (0, _react.useState)(false);
  const rulesTableContext = (0, _rules_table_context.useRulesTableContextOptional)();
  const {
    startTransaction
  } = (0, _use_start_transaction.useStartTransaction)();
  const {
    executeBulkAction
  } = (0, _use_execute_bulk_action.useExecuteBulkAction)({
    suppressSuccessToast: !rulesTableContext
  });
  const onRuleStateChange = (0, _react.useCallback)(async event => {
    setMyIsLoading(true);
    startTransaction({
      name: enabled ? _user_actions.SINGLE_RULE_ACTIONS.DISABLE : _user_actions.SINGLE_RULE_ACTIONS.ENABLE
    });
    const enableRule = event.target.checked;
    if (enableRule) {
      await (startMlJobsIfNeeded === null || startMlJobsIfNeeded === void 0 ? void 0 : startMlJobsIfNeeded());
    }
    const bulkActionResponse = await executeBulkAction({
      type: enableRule ? _request_schema.BulkActionType.enable : _request_schema.BulkActionType.disable,
      ids: [id]
    });
    if (bulkActionResponse !== null && bulkActionResponse !== void 0 && bulkActionResponse.attributes.results.updated.length) {
      // The rule was successfully updated
      onChange === null || onChange === void 0 ? void 0 : onChange(bulkActionResponse.attributes.results.updated[0].enabled);
    }
    setMyIsLoading(false);
  }, [enabled, executeBulkAction, id, onChange, startMlJobsIfNeeded, startTransaction]);
  const showLoader = (0, _react.useMemo)(() => {
    if (myIsLoading !== isLoading) {
      return isLoading || myIsLoading;
    }
    return myIsLoading;
  }, [myIsLoading, isLoading]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "spaceAround",
    id: `rule-switch-${id}`
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, showLoader ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "m",
    "data-test-subj": "ruleSwitchLoader"
  }) : /*#__PURE__*/_react.default.createElement(StaticSwitch, {
    "data-test-subj": "ruleSwitch",
    label: undefined,
    disabled: isDisabled,
    checked: enabled,
    onChange: onRuleStateChange
  })));
};
exports.RuleSwitchComponent = RuleSwitchComponent;
const RuleSwitch = /*#__PURE__*/_react.default.memo(RuleSwitchComponent);
exports.RuleSwitch = RuleSwitch;
RuleSwitch.displayName = 'RuleSwitch';