"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usePreviewHistogram = void 0;
var _react = require("react");
var _common = require("@kbn/data-plugin/common");
var _matrix_histogram = require("../../../../common/containers/matrix_histogram");
var _search_strategy = require("../../../../../common/search_strategy");
var _kuery = require("../../../../common/lib/kuery");
var _kibana = require("../../../../common/lib/kibana");
var _translations = require("./translations");
var _constants = require("../../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const usePreviewHistogram = ({
  previewId,
  startDate,
  endDate,
  spaceId,
  ruleType,
  indexPattern,
  skip
}) => {
  const {
    uiSettings
  } = (0, _kibana.useKibana)().services;
  const [filterQuery, error] = (0, _kuery.convertToBuildEsQuery)({
    config: (0, _common.getEsQueryConfig)(uiSettings),
    indexPattern,
    queries: [{
      query: `kibana.alert.rule.uuid:${previewId}`,
      language: 'kuery'
    }],
    filters: []
  });
  const stackByField = (0, _react.useMemo)(() => {
    return ruleType === 'machine_learning' ? 'host.name' : 'event.category';
  }, [ruleType]);
  const matrixHistogramRequest = (0, _react.useMemo)(() => {
    return {
      endDate,
      errorMessage: _translations.QUERY_PREVIEW_ERROR,
      filterQuery,
      histogramType: _search_strategy.MatrixHistogramType.preview,
      indexNames: [`${_constants.DEFAULT_PREVIEW_INDEX}-${spaceId}`],
      stackByField,
      startDate,
      includeMissingData: false,
      skip: skip || error != null
    };
  }, [endDate, filterQuery, spaceId, stackByField, startDate, skip, error]);
  return (0, _matrix_histogram.useMatrixHistogramCombined)(matrixHistogramRequest);
};
exports.usePreviewHistogram = usePreviewHistogram;