"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VIEW_DETAILS_FOR_ROW = exports.VIEW_DETAILS = exports.RULE_PREVIEW_TITLE = exports.RULE_PREVIEW_ERROR = exports.RULE_PREVIEW_DESCRIPTION = exports.QUICK_PREVIEW_TOGGLE_BUTTON = exports.QUERY_PREVIEW_SELECT_ARIA = exports.QUERY_PREVIEW_SEE_ALL_WARNINGS = exports.QUERY_PREVIEW_SEE_ALL_ERRORS = exports.QUERY_PREVIEW_NOISE_WARNING = exports.QUERY_PREVIEW_LABEL = exports.QUERY_PREVIEW_INVOCATION_COUNT_WARNING_TITLE = exports.QUERY_PREVIEW_INVOCATION_COUNT_WARNING_MESSAGE = exports.QUERY_PREVIEW_ERROR = exports.QUERY_PREVIEW_BUTTON = exports.QUERY_GRAPH_HITS_TITLE = exports.QUERY_GRAPH_COUNT = exports.PREVIEW_TIMEOUT_WARNING = exports.PREVIEW_HISTOGRAM_DISCLAIMER = exports.ML_PREVIEW_HISTOGRAM_DISCLAIMER = exports.LAST_WEEK = exports.LAST_MONTH = exports.LAST_HOUR = exports.LAST_DAY = exports.ADVANCED_PREVIEW_TOGGLE_BUTTON = exports.ACTIONS = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LAST_HOUR = _i18n.i18n.translate('xpack.securitySolution.stepDefineRule.lastHour', {
  defaultMessage: 'Last hour'
});
exports.LAST_HOUR = LAST_HOUR;
const LAST_DAY = _i18n.i18n.translate('xpack.securitySolution.stepDefineRule.lastDay', {
  defaultMessage: 'Last day'
});
exports.LAST_DAY = LAST_DAY;
const LAST_WEEK = _i18n.i18n.translate('xpack.securitySolution.stepDefineRule.lastWeek', {
  defaultMessage: 'Last week'
});
exports.LAST_WEEK = LAST_WEEK;
const LAST_MONTH = _i18n.i18n.translate('xpack.securitySolution.stepDefineRule.lastMonth', {
  defaultMessage: 'Last month'
});
exports.LAST_MONTH = LAST_MONTH;
const QUERY_PREVIEW_BUTTON = _i18n.i18n.translate('xpack.securitySolution.stepDefineRule.previewQueryButton', {
  defaultMessage: 'Preview results'
});
exports.QUERY_PREVIEW_BUTTON = QUERY_PREVIEW_BUTTON;
const QUICK_PREVIEW_TOGGLE_BUTTON = _i18n.i18n.translate('xpack.securitySolution.stepDefineRule.quickPreviewToggleButton', {
  defaultMessage: 'Quick query preview'
});
exports.QUICK_PREVIEW_TOGGLE_BUTTON = QUICK_PREVIEW_TOGGLE_BUTTON;
const ADVANCED_PREVIEW_TOGGLE_BUTTON = _i18n.i18n.translate('xpack.securitySolution.stepDefineRule.advancedPreviewToggleButton', {
  defaultMessage: 'Advanced query preview'
});
exports.ADVANCED_PREVIEW_TOGGLE_BUTTON = ADVANCED_PREVIEW_TOGGLE_BUTTON;
const PREVIEW_TIMEOUT_WARNING = _i18n.i18n.translate('xpack.securitySolution.stepDefineRule.previewTimeoutWarning', {
  defaultMessage: 'Preview timed out after 60 seconds'
});
exports.PREVIEW_TIMEOUT_WARNING = PREVIEW_TIMEOUT_WARNING;
const QUERY_PREVIEW_SELECT_ARIA = _i18n.i18n.translate('xpack.securitySolution.stepDefineRule.previewQueryAriaLabel', {
  defaultMessage: 'Query preview timeframe select'
});
exports.QUERY_PREVIEW_SELECT_ARIA = QUERY_PREVIEW_SELECT_ARIA;
const RULE_PREVIEW_ERROR = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.queryPreview.rulePreviewError', {
  defaultMessage: 'Failed to preview rule'
});
exports.RULE_PREVIEW_ERROR = RULE_PREVIEW_ERROR;
const QUERY_PREVIEW_LABEL = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.queryPreview.queryPreviewLabel', {
  defaultMessage: 'Select a preview timeframe'
});
exports.QUERY_PREVIEW_LABEL = QUERY_PREVIEW_LABEL;
const QUERY_PREVIEW_INVOCATION_COUNT_WARNING_TITLE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.queryPreview.queryPreviewInvocationCountWarningTitle', {
  defaultMessage: 'Rule preview timeframe might cause timeout'
});
exports.QUERY_PREVIEW_INVOCATION_COUNT_WARNING_TITLE = QUERY_PREVIEW_INVOCATION_COUNT_WARNING_TITLE;
const QUERY_PREVIEW_INVOCATION_COUNT_WARNING_MESSAGE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.queryPreview.queryPreviewInvocationCountWarningMessage', {
  defaultMessage: `The timeframe and rule interval that you selected for previewing this rule might cause timeout or take long time to execute. Try to decrease the timeframe and/or increase the interval if preview has timed out (this won't affect the actual rule run).`
});
exports.QUERY_PREVIEW_INVOCATION_COUNT_WARNING_MESSAGE = QUERY_PREVIEW_INVOCATION_COUNT_WARNING_MESSAGE;
const QUERY_GRAPH_COUNT = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.queryPreview.queryGraphCountLabel', {
  defaultMessage: 'Count'
});
exports.QUERY_GRAPH_COUNT = QUERY_GRAPH_COUNT;
const QUERY_GRAPH_HITS_TITLE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.queryPreview.queryPreviewTitle', {
  defaultMessage: 'Rule Preview'
});
exports.QUERY_GRAPH_HITS_TITLE = QUERY_GRAPH_HITS_TITLE;
const QUERY_PREVIEW_NOISE_WARNING = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.queryPreview.queryGraphPreviewNoiseWarning', {
  defaultMessage: 'Noise warning: This rule may cause a lot of noise. Consider narrowing your query. This is based on a linear progression of 1 alert per hour.'
});
exports.QUERY_PREVIEW_NOISE_WARNING = QUERY_PREVIEW_NOISE_WARNING;
const QUERY_PREVIEW_ERROR = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.queryPreview.queryGraphPreviewError', {
  defaultMessage: 'Error fetching preview'
});
exports.QUERY_PREVIEW_ERROR = QUERY_PREVIEW_ERROR;
const PREVIEW_HISTOGRAM_DISCLAIMER = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.queryPreview.histogramDisclaimer', {
  defaultMessage: 'Note: Alerts with multiple event.category values will be counted more than once.'
});
exports.PREVIEW_HISTOGRAM_DISCLAIMER = PREVIEW_HISTOGRAM_DISCLAIMER;
const ML_PREVIEW_HISTOGRAM_DISCLAIMER = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.queryPreview.mlHistogramDisclaimer', {
  defaultMessage: 'Note: Alerts with multiple host.name values will be counted more than once.'
});
exports.ML_PREVIEW_HISTOGRAM_DISCLAIMER = ML_PREVIEW_HISTOGRAM_DISCLAIMER;
const QUERY_PREVIEW_SEE_ALL_ERRORS = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.queryPreview.queryPreviewSeeAllErrors', {
  defaultMessage: 'See all errors'
});
exports.QUERY_PREVIEW_SEE_ALL_ERRORS = QUERY_PREVIEW_SEE_ALL_ERRORS;
const QUERY_PREVIEW_SEE_ALL_WARNINGS = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.queryPreview.queryPreviewSeeAllWarnings', {
  defaultMessage: 'See all warnings'
});
exports.QUERY_PREVIEW_SEE_ALL_WARNINGS = QUERY_PREVIEW_SEE_ALL_WARNINGS;
const ACTIONS = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.queryPreview.actions', {
  defaultMessage: 'Actions'
});
exports.ACTIONS = ACTIONS;
const VIEW_DETAILS = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.queryPreview.viewDetailsAriaLabel', {
  defaultMessage: 'View details'
});
exports.VIEW_DETAILS = VIEW_DETAILS;
const VIEW_DETAILS_FOR_ROW = ({
  ariaRowindex,
  columnValues
}) => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.queryPreview.viewDetailsForRowAriaLabel', {
  values: {
    ariaRowindex,
    columnValues
  },
  defaultMessage: 'View details for the alert or event in row {ariaRowindex}, with columns {columnValues}'
});
exports.VIEW_DETAILS_FOR_ROW = VIEW_DETAILS_FOR_ROW;
const RULE_PREVIEW_TITLE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.rulePreviewTitle', {
  defaultMessage: 'Rule preview'
});
exports.RULE_PREVIEW_TITLE = RULE_PREVIEW_TITLE;
const RULE_PREVIEW_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.rulePreviewDescription', {
  defaultMessage: 'Rule preview reflects the current configuration of your rule settings and exceptions, click refresh icon to see the updated preview.'
});
exports.RULE_PREVIEW_DESCRIPTION = RULE_PREVIEW_DESCRIPTION;