"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getStatusText = exports.getStatusColor = exports.getCapitalizedStatusText = void 0;
var _lodash = require("lodash");
var _utility_types = require("../../../../../common/utility_types");
var _rule_monitoring = require("../../../../../common/detection_engine/rule_monitoring");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getStatusText = value => {
  if (value == null) {
    return null;
  }
  if (value === _rule_monitoring.RuleExecutionStatus['partial failure']) {
    return 'warning';
  }
  return value;
};
exports.getStatusText = getStatusText;
const getCapitalizedStatusText = value => {
  const status = getStatusText(value);
  return status != null ? (0, _lodash.capitalize)(status) : null;
};
exports.getCapitalizedStatusText = getCapitalizedStatusText;
const getStatusColor = status => {
  if (status == null) {
    return 'subdued';
  }
  if (status === _rule_monitoring.RuleExecutionStatus.succeeded) {
    return 'success';
  }
  if (status === _rule_monitoring.RuleExecutionStatus.failed) {
    return 'danger';
  }
  if (status === _rule_monitoring.RuleExecutionStatus.running || status === _rule_monitoring.RuleExecutionStatus['partial failure'] || status === _rule_monitoring.RuleExecutionStatus['going to run']) {
    return 'warning';
  }
  return (0, _utility_types.assertUnreachable)(status, 'Unknown rule execution status');
};
exports.getStatusColor = getStatusColor;