"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleStatusFailedCallOut = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _formatted_date = require("../../../../common/components/formatted_date");
var _rule_monitoring = require("../../../../../common/detection_engine/rule_monitoring");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RuleStatusFailedCallOutComponent = ({
  date,
  message,
  status
}) => {
  const {
    shouldBeDisplayed,
    color,
    title
  } = getPropsByStatus(status);
  if (!shouldBeDisplayed) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    css: `
        pre {
          margin-block-end: 0;
          margin-right: 24px; // Otherwise the copy button overlaps the scrollbar
          padding-inline-end: 0;
        }
      `
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, title, " ", /*#__PURE__*/_react.default.createElement(_formatted_date.FormattedDate, {
      value: date,
      fieldName: "execution_summary.last_execution.date"
    })),
    color: color,
    iconType: "warning",
    "data-test-subj": "ruleStatusFailedCallOut"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    className: "eui-fullWidth",
    paddingSize: "none",
    isCopyable: true,
    overflowHeight: 96,
    transparentBackground: true
  }, message)));
};
const RuleStatusFailedCallOut = /*#__PURE__*/_react.default.memo(RuleStatusFailedCallOutComponent);
exports.RuleStatusFailedCallOut = RuleStatusFailedCallOut;
RuleStatusFailedCallOut.displayName = 'RuleStatusFailedCallOut';
const getPropsByStatus = status => {
  switch (status) {
    case _rule_monitoring.RuleExecutionStatus.failed:
      return {
        shouldBeDisplayed: true,
        color: 'danger',
        title: i18n.ERROR_CALLOUT_TITLE
      };
    case _rule_monitoring.RuleExecutionStatus['partial failure']:
      return {
        shouldBeDisplayed: true,
        color: 'warning',
        title: i18n.PARTIAL_FAILURE_CALLOUT_TITLE
      };
    default:
      return {
        shouldBeDisplayed: false,
        color: 'warning',
        title: ''
      };
  }
};